<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.client',2)); ?> <?php echo e(trans_choice('general.closed',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title"><?php echo e(trans_choice('general.client',2)); ?> <?php echo e(trans_choice('general.closed',1)); ?></h3>

            <div class="box-tools pull-right">
                <?php if(Sentinel::hasAccess('clients.create')): ?>
                    <a href="<?php echo e(url('client/create')); ?>" class="btn btn-info btn-sm">
                        <?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.client',1)); ?>

                    </a>
                <?php endif; ?>
            </div>
        </div>
        <div class="box-body table-responsive">
            <table class="table  table-bordered table-hover table-striped" id="data-table">
                <thead>
                <tr>
                    <th><?php echo e(trans_choice('general.name',1)); ?></th>
                    <th><?php echo e(trans_choice('general.client',1)); ?> <?php echo e(trans('general.id')); ?></th>
                    <th><?php echo e(trans('general.nrc_number')); ?></th>
                    <th><?php echo e(trans_choice('general.branch',1)); ?></th>
                    <th><?php echo e(trans_choice('general.staff',1)); ?></th>
                    <th><?php echo e(trans_choice('general.action',1)); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <?php if($key->client_type=="individual"): ?>
                                <?php echo e($key->first_name); ?>   <?php echo e($key->middle_name); ?>   <?php echo e($key->last_name); ?>

                            <?php else: ?>
                                <?php echo e($key->full_name); ?>

                            <?php endif; ?>
                        </td>
                        <td><?php echo e($key->account_no); ?></td>
                        <td><?php echo e($key->nrc_number); ?></td>
                        <td>
                            <?php if(!empty($key->office)): ?>
                                <?php echo e($key->office->name); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if(!empty($key->staff)): ?>
                                <?php echo e($key->staff->first_name); ?>   <?php echo e($key->staff->last_name); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="btn-group">
                                <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown"
                                        aria-expanded="false"><i
                                            class="fa fa-navicon"></i></button>
                                <ul class="dropdown-menu dropdown-menu-right" role="menu">
                                    <?php if(Sentinel::hasAccess('clients.view')): ?>
                                        <li>
                                            <a href="<?php echo e(url('client/'.$key->id.'/show')); ?>"><i
                                                        class="fa fa-search"></i>
                                                <?php echo e(trans_choice('general.detail',2)); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(Sentinel::hasAccess('clients.update')): ?>
                                        <li>
                                            <a href="<?php echo e(url('client/'.$key->id.'/edit')); ?>"><i
                                                        class="fa fa-edit"></i>
                                                <?php echo e(trans('general.edit')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(Sentinel::hasAccess('clients.delete')): ?>
                                        <li>
                                            <a href="<?php echo e(url('client/'.$key->id.'/delete')); ?>"
                                               class="delete"><i
                                                        class="fa fa-trash"></i>
                                                <?php echo e(trans('general.delete')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>

        $('#data-table').DataTable({
            dom: 'frtip',
            "paging": true,
            "lengthChange": true,
            "displayLength": 15,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": true,
            "order": [[0, "asc"]],
            "columnDefs": [
                {"orderable": false, "targets": []}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\kwickfoxloan\resources\views/client/closed.blade.php ENDPATH**/ ?>