<?php $__env->startSection('title'); ?>
    <?php echo e(trans('general.edit')); ?> <?php echo e(trans_choice('general.role',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title"><?php echo e(trans('general.edit')); ?> <?php echo e(trans_choice('general.role',1)); ?></h3>

        </div>
        <form action="<?php echo e(url('user/role/'.$role->id.'/update')); ?>" method="post" class="form">
            <?php echo e(csrf_field()); ?>

            <div class="box-body">


                <div class="form-group">
                    <label for="name"><?php echo e(trans_choice('general.name',1)); ?></label>
                    <input type="text" name="name" value="<?php echo e($role->name); ?>" class="form-control" required id="name">
                </div>
                <div class="form-group">
                    <label for="time_limit"><?php echo e(trans_choice('general.time_limit',1)); ?>?</label>
                    <select name="time_limit" id="time_limit" class="form-control">
                        <option value="0"
                                <?php if($role->time_limit==0): ?> selected <?php endif; ?> ><?php echo e(trans_choice('general.no',1)); ?></option>
                        <option value="1"
                                <?php if($role->time_limit==1): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.yes',1)); ?></option>
                    </select>
                </div>
                <div id="time_div">
                    <div class="form-group">
                        <div class="row">
                            <div class="col-md-4">
                                <label for="from_time"><?php echo e(trans_choice('general.from_time',1)); ?></label>
                                <input type="text" name="from_time" value="<?php echo e($role->from_time); ?>"
                                       class="form-control time-picker" required
                                       id="from_time">
                            </div>
                            <div class="col-md-4">
                                <label for="to_time"><?php echo e(trans_choice('general.to_time',1)); ?></label>
                                <input type="text" name="to_time" value="<?php echo e($role->to_time); ?>"
                                       class="form-control time-picker" required
                                       id="to_time">
                            </div>
                            <div class="col-md-4">
                                <label for="access_days"><?php echo e(trans_choice('general.day',2)); ?></label>
                                <select name="access_days[]" id="access_days" class="form-control select2" multiple>
                                    <option value="monday"
                                            <?php if(in_array("monday",json_decode($role->access_days))): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.monday',1)); ?></option>
                                    <option value="tuesday"
                                            <?php if(in_array("tuesday",json_decode($role->access_days))): ?> selected <?php endif; ?> ><?php echo e(trans_choice('general.tuesday',1)); ?></option>
                                    <option value="wednesday"
                                            <?php if(in_array("wednesday",json_decode($role->access_days))): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.wednesday',1)); ?></option>
                                    <option value="thursday"
                                            <?php if(in_array("thursday",json_decode($role->access_days))): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.thursday',1)); ?></option>
                                    <option value="friday"
                                            <?php if(in_array("friday",json_decode($role->access_days))): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.friday',1)); ?></option>
                                    <option value="saturday"
                                            <?php if(in_array("saturday",json_decode($role->access_days))): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.saturday',1)); ?></option>
                                    <option value="sunday"
                                            <?php if(in_array("sunday",json_decode($role->access_days))): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.sunday',1)); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <hr>
                    <h4><?php echo e(trans_choice('general.manage',1)); ?> <?php echo e(trans_choice('general.permission',2)); ?></h4>

                    <div class="col-md-6">
                        <table class="table table-stripped table-hover">
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <?php if($permission->parent_id==0): ?>
                                            <strong><?php echo e($permission->name); ?></strong>
                                        <?php else: ?>
                                            __ <?php echo e($permission->name); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if(!empty($permission->description)): ?>
                                            <i class="fa fa-info" data-toggle="tooltip"
                                               data-original-title="<?php echo $permission->description; ?>"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <input <?php if(array_key_exists($permission->slug,$role->permissions)): ?> checked=""
                                               <?php endif; ?> type="checkbox" data-parent="<?php echo e($permission->parent_id); ?>"
                                               name="permission[]" value="<?php echo e($permission->slug); ?>"
                                               id="<?php echo e($permission->id); ?>"
                                               class="form-control pcheck">
                                        <label class="" for="<?php echo e($permission->id); ?>">

                                        </label>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    </div>
                </div>
            </div>
            <!-- /.box-body -->
            <div class="box-footer">
                <button type="submit" class="btn btn-primary pull-right"><?php echo e(trans_choice('general.save',1)); ?></button>
            </div>
        </form>
    </div>
    <script>
        $(document).ready(function () {
            if ($("#time_limit").val() == "0") {
                $("#time_div").hide();
                $("#from_time").removeAttr("required");
                $("#to_time").removeAttr("required");
                $("#access_days").removeAttr("required");

            } else {
                $("#time_div").show();
                $("#from_time").attr("required", "required");
                $("#to_time").attr("required", "required");
                $("#access_days").attr("required", "required");
            }
            $("#time_limit").change(function () {
                if ($("#time_limit").val() == "0") {
                    $("#time_div").hide();
                    $("#from_time").removeAttr("required");
                    $("#to_time").removeAttr("required");
                    $("#access_days").removeAttr("required");

                } else {
                    $("#time_div").show();
                    $("#from_time").attr("required", "required");
                    $("#to_time").attr("required", "required");
                    $("#access_days").attr("required", "required");
                }
            });
            $(".pcheck").on('ifChecked', function (e) {
                if ($(this).attr('data-parent') == 0) {
                    var id = $(this).attr('id');
                    $(":checkbox[data-parent=" + id + "]").iCheck('check');

                }
            });
            $(".pcheck").on('ifUnchecked', function (e) {
                if ($(this).attr('data-parent') == 0) {
                    var id = $(this).attr('id');
                    $(":checkbox[data-parent=" + id + "]").iCheck('uncheck');

                }
            });
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ic026402/public_html/cres/resources/views/user/role/edit.blade.php ENDPATH**/ ?>