<?php $__env->startSection('title'); ?><?php echo e(trans_choice('general.charge',2)); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="box box-primary">
        <div class="box-header with-border">
            <h6 class="box-title"><?php echo e(trans_choice('general.charge',2)); ?></h6>

            <div class="box-tools pull-right">
                <?php if(Sentinel::hasAccess('products.charges.create')): ?>
                    <a href="<?php echo e(url('charge/create')); ?>"
                       class="btn btn-info btn-sm"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.charge',1)); ?></a>
                <?php endif; ?>
            </div>
        </div>
        <div class="box-body table-responsive">
            <table id="data-table" class="table table-striped table-condensed table-hover ">
                <thead>
                <tr>
                    <th><?php echo e(trans_choice('general.name',1)); ?></th>
                    <th><?php echo e(trans_choice('general.product',1)); ?></th>
                    <th><?php echo e(trans_choice('general.type',1)); ?></th>
                    <th><?php echo e(trans_choice('general.active',1)); ?></th>
                    <th><?php echo e(trans_choice('general.amount',1)); ?></th>
                    <th><?php echo e(trans_choice('general.action',1)); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key->name); ?></td>
                        <td>
                            <?php if($key->product=='loan'): ?>
                                <?php echo e(trans_choice('general.loan',1)); ?>

                            <?php endif; ?>
                            <?php if($key->product=='savings'): ?>
                                <?php echo e(trans_choice('general.savings',1)); ?>

                            <?php endif; ?>
                            <?php if($key->product=='client'): ?>
                                <?php echo e(trans_choice('general.client',1)); ?>

                            <?php endif; ?>
                            <?php if($key->product=='shares'): ?>
                                <?php echo e(trans_choice('general.shares',1)); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($key->charge_type=='disbursement'): ?>
                                <?php echo e(trans_choice('general.disbursement',1)); ?>

                            <?php endif; ?>
                            <?php if($key->charge_type=='specified_due_date'): ?>
                                <?php echo e(trans_choice('general.specified_due_date',2)); ?>

                            <?php endif; ?>
                            <?php if($key->charge_type=='installment_fee'): ?>
                                <?php echo e(trans_choice('general.installment_fee',2)); ?>

                            <?php endif; ?>
                            <?php if($key->charge_type=='overdue_installment_fee'): ?>
                                <?php echo e(trans_choice('general.overdue_installment_fee',2)); ?>

                            <?php endif; ?>
                            <?php if($key->charge_type=='loan_rescheduling_fee'): ?>
                                <?php echo e(trans_choice('general.loan_rescheduling_fee',2)); ?>

                            <?php endif; ?>
                            <?php if($key->charge_type=='overdue_maturity'): ?>
                                <?php echo e(trans_choice('general.overdue_maturity',2)); ?>

                            <?php endif; ?>
                            <?php if($key->charge_type=='savings_activation'): ?>
                                <?php echo e(trans_choice('general.savings_activation',2)); ?>

                            <?php endif; ?>
                            <?php if($key->charge_type=='withdrawal_fee'): ?>
                                <?php echo e(trans_choice('general.withdrawal_fee',2)); ?>

                            <?php endif; ?>
                            <?php if($key->charge_type=='monthly_fee'): ?>
                                <?php echo e(trans_choice('general.monthly_fee',2)); ?>

                            <?php endif; ?>
                            <?php if($key->charge_type=='annual_fee'): ?>
                                <?php echo e(trans_choice('general.annual_fee',2)); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($key->active==1): ?>
                                <?php echo e(trans_choice('general.yes',1)); ?>

                            <?php else: ?>
                                <?php echo e(trans_choice('general.no',1)); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <?php echo e($key->amount); ?>

                            <?php if($key->charge_option=="flat"): ?>
                                <?php echo e(trans_choice('general.flat',1)); ?>

                            <?php endif; ?>
                            <?php if($key->charge_option=="installment_principal_due"): ?>
                                % <?php echo e(trans_choice('general.installment_principal_due',1)); ?>

                            <?php endif; ?>
                            <?php if($key->charge_option=="installment_principal_interest_due"): ?>
                                % <?php echo e(trans_choice('general.installment_principal_interest_due',1)); ?>

                            <?php endif; ?>
                            <?php if($key->charge_option=="installment_interest_due"): ?>
                                % <?php echo e(trans_choice('general.installment_interest_due',1)); ?>

                            <?php endif; ?>
                            <?php if($key->charge_option=="total_due"): ?>
                                % <?php echo e(trans_choice('general.total_due',1)); ?>

                            <?php endif; ?>
                            <?php if($key->charge_option=="original_principal"): ?>
                                % <?php echo e(trans_choice('general.original_principal',1)); ?>

                            <?php endif; ?>
                            <?php if($key->charge_option=="percentage"): ?>
                                % <?php echo e(trans_choice('general.percentage',1)); ?> <?php echo e(trans_choice('general.of',1)); ?> <?php echo e(trans_choice('general.amount',1)); ?>

                            <?php endif; ?>

                        </td>
                        <td>
                            <div class="btn-group">
                                <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown"
                                        aria-expanded="false"><i
                                            class="fa fa-navicon"></i></button>
                                <ul class="dropdown-menu dropdown-menu-right" role="menu">
                                    <?php if(Sentinel::hasAccess('products.charges.update')): ?>
                                        <li>
                                            <a href="<?php echo e(url('charge/'.$key->id.'/edit')); ?>"><i
                                                        class="fa fa-edit"></i>
                                                <?php echo e(trans('general.edit')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(Sentinel::hasAccess('products.charges.delete')): ?>
                                        <li>
                                            <a href="<?php echo e(url('charge/'.$key->id.'/delete')); ?>"
                                               class="delete"><i
                                                        class="fa fa-trash"></i>
                                                <?php echo e(trans('general.delete')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <!-- /.box-body -->
    </div>
    <!-- /.box -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>

        $('#data-table').DataTable({
            dom: 'frtip',
            "paging": true,
            "lengthChange": true,
            "displayLength": 15,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": true,
            "order": [[0, "asc"]],
            "columnDefs": [
                {"orderable": false, "targets": []}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ic026402/public_html/cres/resources/views/charge/data.blade.php ENDPATH**/ ?>