<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.reconciliation',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="box box-primary">

        <div class="box-body hidden-print">
            <form method="post" action="<?php echo e(Request::url()); ?>" class="form-horizontal" enctype="multipart/form-data">
                <?php echo e(csrf_field()); ?>

                <div class="form-group">
                    <label for="gl_account_id"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.account',1)); ?></label>
                    <div class="col-md-3">
                        <select name="gl_account_id" class="form-control select2" id="gl_account_id">
                            <?php $__currentLoopData = \App\Models\GlAccount::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key->id); ?>"
                                        <?php if($gl_account_id==$key->id): ?> selected <?php endif; ?>><?php echo e($key->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label for="office_id"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.office',1)); ?></label>
                    <div class="col-md-3">
                        <select name="office_id" class="form-control select2" id="office_id">
                            <option value="0"
                                    <?php if($office_id==0): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.all',1)); ?></option>
                            <?php $__currentLoopData = \App\Models\Office::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key->id); ?>"
                                        <?php if($office_id==$key->id): ?> selected <?php endif; ?>><?php echo e($key->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <label for="start_date"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.start',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="start_date" class="form-control date-picker"
                               value="<?php echo e($start_date); ?>"
                               required id="start_date">
                    </div>
                </div>
                <div class="form-group">
                    <label for="end_date"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.end',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="end_date" class="form-control date-picker"
                               value="<?php echo e($end_date); ?>"
                               required id="end_date">
                    </div>
                </div>
                <div class="form-group">
                    <label for="show"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.show',1)); ?></label>
                    <div class="col-md-3">
                        <select name="show" class="form-control select2" id="show">
                            <option value="0"
                                    <?php if($show==0): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.all',1)); ?></option>
                            <option value="1"
                                    <?php if($show==1): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.unreconciled',1)); ?></option>
                            <option value="2"
                                    <?php if($show==2): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.reconciled',1)); ?></option>
                        </select>
                    </div>
                </div>


                <div class="form-group">
                    <label for=""
                           class="control-label col-md-2"></label>
                    <div class="col-md-4">
                        <button type="submit" class="btn btn-success" id="search"><?php echo e(trans_choice('general.search',1)); ?>!
                        </button>

                        <a href="<?php echo e(Request::url()); ?>"
                           class="btn btn-danger"><?php echo e(trans_choice('general.reset',1)); ?>!</a>
                    </div>
                </div>
            </form>

        </div>
        <!-- /.box-body -->

    </div>
    <!-- /.box -->
    <?php if(!empty($start_date)): ?>
        <div class="box box-white">
            <div class="box-body ">
                <form method="post" action="<?php echo e(url('accounting/reconciliation/store')); ?>" id="reconcile_form"
                      class="form-horizontal" enctype="multipart/form-data">
                    <?php echo e(csrf_field()); ?>

                    <div class="table-responsive">
                        <table id="data-table" class="table table-striped table-condensed table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th><?php echo e(trans_choice('general.transaction',1)); ?> <?php echo e(trans_choice('general.id',1)); ?></th>
                                <th><?php echo e(trans_choice('general.transaction',1)); ?> <?php echo e(trans_choice('general.type',1)); ?></th>
                                <th><?php echo e(trans_choice('general.date',1)); ?></th>
                                <th><?php echo e(trans_choice('general.office',1)); ?></th>
                                <th><?php echo e(trans_choice('general.account',1)); ?></th>
                                <th><?php echo e(trans_choice('general.debit',1)); ?></th>
                                <th><?php echo e(trans_choice('general.credit',1)); ?></th>
                                <th>
                                    <label>
                                        <input type="checkbox" class="" name="" value="0"
                                               id="reconcile_select_all">
                                    </label>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($key->id); ?></td>
                                    <td><?php echo e($key->reference); ?></td>
                                    <td>
                                        <?php if($key->transaction_type=='disbursement'): ?>
                                            <?php echo e(trans_choice('general.disbursement',1)); ?>

                                        <?php endif; ?>
                                        <?php if($key->transaction_type=='accrual'): ?>
                                            <?php echo e(trans_choice('general.accrual',1)); ?>

                                        <?php endif; ?>
                                        <?php if($key->transaction_type=='deposit'): ?>
                                            <?php echo e(trans_choice('general.deposit',1)); ?>

                                        <?php endif; ?>
                                        <?php if($key->transaction_type=='withdrawal'): ?>
                                            <?php echo e(trans_choice('general.withdrawal',1)); ?>

                                        <?php endif; ?>
                                        <?php if($key->transaction_type=='manual_entry'): ?>
                                            <?php echo e(trans_choice('general.manual_entry',2)); ?>

                                        <?php endif; ?>
                                        <?php if($key->transaction_type=='pay_charge'): ?>
                                            <?php echo e(trans_choice('general.pay',1)); ?>    <?php echo e(trans_choice('general.charge',1)); ?>

                                        <?php endif; ?>
                                        <?php if($key->transaction_type=='transfer_fund'): ?>
                                            <?php echo e(trans_choice('general.transfer_fund',1)); ?> <?php echo e(trans_choice('general.charge',2)); ?>

                                        <?php endif; ?>
                                        <?php if($key->transaction_type=='expense'): ?>
                                            <?php echo e(trans_choice('general.expense',1)); ?>

                                        <?php endif; ?>
                                        <?php if($key->transaction_type=='payroll'): ?>
                                            <?php echo e(trans_choice('general.payroll',1)); ?>

                                        <?php endif; ?>
                                        <?php if($key->transaction_type=='income'): ?>
                                            <?php echo e(trans_choice('general.income',1)); ?>

                                        <?php endif; ?>
                                        <?php if($key->transaction_type=='penalty'): ?>
                                            <?php echo e(trans_choice('general.penalty',1)); ?>

                                        <?php endif; ?>
                                        <?php if($key->transaction_type=='fee'): ?>
                                            <?php echo e(trans_choice('general.fee',1)); ?>

                                        <?php endif; ?>
                                        <?php if($key->transaction_type=='close_write_off'): ?>
                                            <?php echo e(trans_choice('general.write',1)); ?>  <?php echo e(trans_choice('general.waiver',2)); ?>

                                        <?php endif; ?>
                                        <?php if($key->transaction_type=='repayment_recovery'): ?>
                                            <?php echo e(trans_choice('general.repayment',1)); ?>

                                        <?php endif; ?>
                                        <?php if($key->transaction_type=='repayment'): ?>
                                            <?php echo e(trans_choice('general.repayment',1)); ?>

                                        <?php endif; ?>
                                        <?php if($key->transaction_type=='interest_accrual'): ?>
                                            <?php echo e(trans_choice('general.interest',1)); ?> <?php echo e(trans_choice('general.accrual',1)); ?>

                                        <?php endif; ?>
                                        <?php if($key->transaction_type=='fee_accrual'): ?>
                                            <?php echo e(trans_choice('general.fee',1)); ?> <?php echo e(trans_choice('general.accrual',1)); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($key->date); ?></td>
                                    <td>
                                        <?php if(!empty($key->office)): ?>
                                            <?php echo e($key->office->name); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if(!empty($key->gl_account)): ?>
                                            <?php echo e($key->gl_account->name); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(number_format($key->debit,2)); ?></td>
                                    <td><?php echo e(number_format($key->credit,2)); ?></td>
                                    <td>
                                        <?php if($key->reconciled==1): ?>
                                            <span class="label label-success"><?php echo e(trans_choice('general.reconciled',1)); ?></span>
                                        <?php else: ?>
                                            <label>
                                                <input type="checkbox" class="reconcile_checkbox" name="reconcile_ids[]"
                                                       value="<?php echo e($key->id); ?>"
                                                       id="reconcile_<?php echo e($key->id); ?>">
                                            </label>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <?php if(!Sentinel::hasAccess('accounting.journals.reconciliation.create')): ?>
                        <button type="submit" class="btn btn-success pull-right"
                                id="save_reconcile"><?php echo e(trans_choice('general.save',1)); ?>

                        </button>
                    <?php endif; ?>
                </form>
            </div>
            <!-- /.box-body -->
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>
        var table = $('#data-table').DataTable({
            "order": [[0, "asc"]],
            "columnDefs": [
                {"orderable": false, "targets": [8]}
            ],
            "pageLength": 30,
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
        $("#reconcile_select_all").on('ifChecked', function (e) {
            //$(".reconcile_checkbox").iCheck('check');
            var cells = table.cells().nodes();
            $(cells).find('.reconcile_checkbox').iCheck('check');
        });
        $("#reconcile_select_all").on('ifUnchecked', function (e) {
            var cells = table.cells().nodes();
            $(cells).find('.reconcile_checkbox').iCheck('uncheck');
        });
        $("#save_reconcile").click(function (e) {
            e.preventDefault();
            swal({
                title: 'Are you sure?',
                text: 'This will save all marked transactions as reconciled',
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ok',
                cancelButtonText: 'Cancel'
            }).then(function () {
                $("#reconcile_form").submit();
            })
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\kwickfoxloan\resources\views/journal/reconciliation.blade.php ENDPATH**/ ?>