<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.custom_field',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Default box -->
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title"><?php echo e(trans_choice('general.custom_field',2)); ?></h3>

            <div class="box-tools pull-right">
                <?php if(Sentinel::hasAccess('custom_fields.create')): ?>
                    <a href="<?php echo e(url('custom_field/create')); ?>"
                       class="btn btn-info btn-sm"><?php echo e(trans_choice('general.add',2)); ?> <?php echo e(trans_choice('general.custom_field',1)); ?></a>
            </div>
            <?php endif; ?>
        </div>
        <div class="box-body">
            <table id="data-table" class="table table-bordered table-hover">
                <thead>
                <tr>
                    <th><?php echo e(trans_choice('general.name',1)); ?></th>
                    <th><?php echo e(trans_choice('general.category',1)); ?></th>
                    <th><?php echo e(trans_choice('general.required',1)); ?> <?php echo e(trans_choice('general.field',1)); ?></th>
                    <th><?php echo e(trans_choice('general.type',1)); ?></th>
                    <th><?php echo e(trans_choice('general.action',1)); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key->name); ?></td>
                        <td>
                            <?php if($key->category=="loans"): ?>
                                <?php echo e(trans_choice('general.loan',2)); ?>

                            <?php endif; ?>
                            <?php if($key->category=="clients"): ?>
                                <?php echo e(trans_choice('general.client',2)); ?>

                            <?php endif; ?>
                            <?php if($key->category=="savings"): ?>
                                <?php echo e(trans_choice('general.savings',2)); ?>

                            <?php endif; ?>
                            <?php if($key->category=="groups"): ?>
                                <?php echo e(trans_choice('general.group',2)); ?>

                            <?php endif; ?>
                            <?php if($key->category=="offices"): ?>
                                <?php echo e(trans_choice('general.branch',2)); ?>

                            <?php endif; ?>
                            <?php if($key->category=="users"): ?>
                                <?php echo e(trans_choice('general.user',2)); ?>

                            <?php endif; ?>
                            <?php if($key->category=="collateral"): ?>
                                <?php echo e(trans_choice('general.collateral',1)); ?>

                            <?php endif; ?>
                            <?php if($key->category=="guarantors"): ?>
                                <?php echo e(trans_choice('general.guarantor',2)); ?>

                            <?php endif; ?>
                            <?php if($key->category=="repayments"): ?>
                                <?php echo e(trans_choice('general.repayment',2)); ?>

                            <?php endif; ?>
                            <?php if($key->category=="expenses"): ?>
                                <?php echo e(trans_choice('general.expense',2)); ?>

                            <?php endif; ?>
                            <?php if($key->category=="other_income"): ?>
                                <?php echo e(trans_choice('general.other_income',2)); ?>

                            <?php endif; ?>
                            <?php if($key->category=="repayments"): ?>
                                <?php echo e(trans_choice('general.repayment',2)); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($key->required==0): ?>
                                <?php echo e(trans_choice('general.no',1)); ?>

                            <?php else: ?>
                                <?php echo e(trans_choice('general.yes',1)); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($key->field_type=="number"): ?>
                                <?php echo e(trans_choice('general.number_field',1)); ?>

                            <?php endif; ?>
                            <?php if($key->field_type=="textfield"): ?>
                                <?php echo e(trans_choice('general.text_field',1)); ?>

                            <?php endif; ?>
                            <?php if($key->field_type=="textarea"): ?>
                                <?php echo e(trans_choice('general.text_area',1)); ?>

                            <?php endif; ?>
                            <?php if($key->field_type=="decimal"): ?>
                                <?php echo e(trans_choice('general.decimal_field',1)); ?>

                            <?php endif; ?>
                            <?php if($key->field_type=="date"): ?>
                                <?php echo e(trans_choice('general.date_field',1)); ?>

                            <?php endif; ?>
                            <?php if($key->field_type=="radiobox"): ?>
                                <?php echo e(trans_choice('general.radio_box',1)); ?>

                            <?php endif; ?>
                            <?php if($key->field_type=="select"): ?>
                                <?php echo e(trans_choice('general.select',1)); ?>

                            <?php endif; ?>
                            <?php if($key->field_type=="checkbox"): ?>
                                <?php echo e(trans_choice('general.checkbox',1)); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="btn-group">
                                <button type="button" class="btn btn-info btn-flat dropdown-toggle"
                                        data-toggle="dropdown" aria-expanded="false">
                                    <?php echo e(trans('general.choose')); ?> <span class="caret"></span>
                                    <span class="sr-only">Toggle Dropdown</span>
                                </button>
                                <ul class="dropdown-menu" role="menu">
                                    <?php if(Sentinel::hasAccess('custom_fields.update')): ?>
                                        <li><a href="<?php echo e(url('custom_field/'.$key->id.'/edit')); ?>"><i
                                                        class="fa fa-edit"></i> <?php echo e(trans('general.edit')); ?> </a></li>
                                    <?php endif; ?>
                                    <?php if(Sentinel::hasAccess('custom_fields.delete')): ?>
                                        <li><a href="<?php echo e(url('custom_field/'.$key->id.'/delete')); ?>"
                                               class="delete"><i
                                                        class="fa fa-trash"></i> <?php echo e(trans('general.delete')); ?> </a></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <!-- /.box-body -->
    </div>
    <!-- /.box -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>
        $('#data-table').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": false,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }

            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ic026402/public_html/cres/resources/views/custom_field/data.blade.php ENDPATH**/ ?>