<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.user',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.user',1)); ?></h3>

            <div class="box-tools pull-right">

            </div>
        </div>
        <form method="post" action="<?php echo e(url('user/store')); ?>" class="form" enctype="multipart/form-data">
            <?php echo e(csrf_field()); ?>

            <div class="box-body">
                <div class="form-group">
                    <label for="first_name"
                           class=""><?php echo e(trans_choice('general.first_name',1)); ?></label>
                    <input type="text" name="first_name" class="form-control"
                           placeholder="<?php echo e(trans_choice('general.first_name',1)); ?>"
                           value="<?php echo e(old('first_name')); ?>"
                           required id="first_name">
                </div>
                <div class="form-group">
                    <label for="last_name"
                           class=""><?php echo e(trans_choice('general.last_name',1)); ?></label>
                    <input type="text" name="last_name" class="form-control"
                           placeholder="<?php echo e(trans_choice('general.last_name',1)); ?>"
                           value="<?php echo e(old('last_name')); ?>"
                           required id="last_name">
                </div>
                <div class="form-group">
                    <label for="gender"
                           class=""><?php echo e(trans_choice('general.gender',1)); ?></label>
                    <select name="gender" class="form-control" id="gender">
                        <option value="male"><?php echo e(trans('general.male')); ?></option>
                        <option value="female"><?php echo e(trans('general.female')); ?></option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="phone"
                           class=""><?php echo e(trans_choice('general.phone',1)); ?></label>
                    <input type="text" name="phone" class="form-control"
                           placeholder="<?php echo e(trans_choice('general.phone',1)); ?>"
                           value="<?php echo e(old('phone')); ?>"
                           id="phone">
                </div>
                <div class="form-group ">
                    <label for="email"
                           class=""><?php echo e(trans_choice('general.email',1)); ?></label>
                    <input type="email" name="email" class="form-control"
                           placeholder="<?php echo e(trans_choice('general.email',1)); ?>"
                           value="<?php echo e(old('email')); ?>" required
                           id="email">
                </div>
                <div class="form-group">
                    <label for="password"
                           class=""><?php echo e(trans_choice('general.password',1)); ?></label>
                    <input type="password" name="password" class="form-control"
                           placeholder="<?php echo e(trans_choice('general.password',1)); ?>"
                           value="" required
                           id="password">
                </div>
                <div class="form-group">
                    <label for="repeat_password"
                           class=""><?php echo e(trans_choice('general.repeat_password',1)); ?></label>
                    <input type="password" name="repeat_password" class="form-control"
                           placeholder="<?php echo e(trans_choice('general.repeat_password',1)); ?>"
                           value="" required
                           id="repeat_password">
                </div>
                <div class="form-group">
                    <label for="office_id"><?php echo e(trans_choice('general.office',1)); ?></label>
                           <select name="office_id" class="form-control select2" id="office_id" required>
                            <option></option>
                            <?php $__currentLoopData = \App\Models\Office::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key->id); ?>"><?php echo e($key->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                <div class="form-group">
                    <label for="role"
                           class=""><?php echo e(trans_choice('general.role',1)); ?></label>
                    <select name="role" class="form-control select2" id="role" required>
                        <?php $__currentLoopData = DB::table('roles')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key->id); ?>"><?php echo e($key->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="address"
                           class=""><?php echo e(trans_choice('general.address',1)); ?></label>
                    <textarea name="address" class="form-control wysihtml5"
                              placeholder="<?php echo e(trans_choice('general.address',1)); ?>"
                              id="address" rows="3"><?php echo e(old('address')); ?></textarea>
                </div>
                <div class="form-group">
                    <label for="notes"
                           class=""><?php echo e(trans_choice('general.note',2)); ?></label>
                    <textarea name="notes" class="form-control wysihtml5"
                              placeholder="<?php echo e(trans_choice('general.note',2)); ?>"
                              id="notes" rows="3"><?php echo e(old('notes')); ?></textarea>
                </div>
                <?php if(\App\Models\Setting::where('setting_key','enable_custom_fields')->first()->setting_value==1): ?>
                    <?php $__currentLoopData = \App\Models\CustomField::where('category','users')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="form-group">
                            <label for="notes"
                                   class="control-label col-md-2"><?php echo e($key->name); ?></label>
                            <div class="col-md-8">
                                <?php if($key->field_type=="number"): ?>
                                    <input type="number" class="form-control" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="textfield"): ?>
                                    <input type="text" class="form-control" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="date"): ?>
                                    <input type="text" class="form-control date-picker" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="textarea"): ?>
                                    <textarea class="form-control" name="custom_field_<?php echo e($key->id); ?>"
                                              <?php if($key->required==1): ?> required <?php endif; ?>></textarea>
                                <?php endif; ?>
                                <?php if($key->field_type=="decimal"): ?>
                                    <input type="text" class="form-control touchspin" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="select"): ?>
                                    <select class="form-control touchspin" name="custom_field_<?php echo e($key->id); ?>"
                                            <?php if($key->required==1): ?> required <?php endif; ?>>
                                        <?php if($key->required!=1): ?>
                                            <option value=""></option>
                                        <?php else: ?>
                                            <option value="" disabled selected>Select...</option>
                                        <?php endif; ?>
                                        <?php $__currentLoopData = explode(',',$key->select_values); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option><?php echo e($v); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                <?php endif; ?>
                                <?php if($key->field_type=="radiobox"): ?>
                                    <?php $__currentLoopData = explode(',',$key->radio_box_values); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="radio">
                                            <label>
                                                <input type="radio" name="custom_field_<?php echo e($key->id); ?>" id="<?php echo e($key->id); ?>" value="<?php echo e($v); ?>"
                                                       <?php if($key->required==1): ?> required <?php endif; ?>>
                                                <b><?php echo e($v); ?></b>
                                            </label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                <?php if($key->field_type=="checkbox"): ?>
                                    <?php $__currentLoopData = explode(',',$key->checkbox_values); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="checkbox">
                                            <label>
                                                <input type="checkbox" name="custom_field_<?php echo e($key->id); ?>[<?php echo e($v); ?>]" id="<?php echo e($key->id); ?>"
                                                       value="<?php echo e($v); ?>"
                                                       <?php if($key->required==1): ?> required <?php endif; ?>>
                                                <b><?php echo e($v); ?></b>
                                            </label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
            <!-- /.box-body -->
            <div class="box-footer">
                <div class="heading-elements">
                    <button type="submit" class="btn btn-primary pull-right"><?php echo e(trans_choice('general.save',1)); ?></button>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script src="<?php echo e(asset('assets/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js')); ?>"></script>
    <script>
        $(".form").validate({
            rules: {
                field: {
                    required: true,
                    step: 10
                }, password: {
                    required: true,
                    minlength: 6,
                },
                repeat_password: {
                    required: true,
                    minlength: 6,
                    equalTo: "#password"
                }
            }, highlight: function (element) {
                $(element).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (element) {
                $(element).closest('.form-group').removeClass('has-error');
            },
            errorElement: 'span',
            errorClass: 'help-block',
            errorPlacement: function (error, element) {
                if (element.parent('.input-group').length) {
                    error.insertAfter(element.parent());
                } else {
                    error.insertAfter(element);
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ic026402/public_html/cres/resources/views/user/create.blade.php ENDPATH**/ ?>