<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.expense',1)); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.expense',1)); ?></h3>

            <div class="box-tools pull-right">

            </div>
        </div>
        <form method="post" action="<?php echo e(url('expense/store')); ?>" class="form-horizontal" enctype="multipart/form-data">
            <?php echo e(csrf_field()); ?>

            <div class="box-body">
                <div class="form-group">
                    <label for="office_id"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.branch',1)); ?></label>
                    <div class="col-md-3">
                        <select name="office_id" class="form-control select2" id="office_id" required>
                            <option></option>
                            <?php $__currentLoopData = \App\Models\Office::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key->id); ?>"><?php echo e($key->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label for="expense_type_id"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.type',1)); ?></label>
                    <div class="col-md-3">
                        <select name="expense_type_id" class="form-control select2" id="expense_type_id"
                                required>
                            <option></option>
                            <?php $__currentLoopData = \App\Models\ExpenseType::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key->id); ?>"><?php echo e($key->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label for="name"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.name',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="name" class="form-control"
                               value="<?php echo e(old('name')); ?>"
                               id="name">
                    </div>
                </div>
                <div class="form-group">
                    <label for="date"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.date',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="date" class="form-control date-picker"
                               value="<?php echo e(date('Y-m-d')); ?>"
                               id="date">
                    </div>
                </div>
                <div class="form-group">
                    <label for="amount"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.amount',1)); ?></label>
                    <div class="col-md-3">
                        <input type="number" name="amount" class="form-control"
                               value="<?php echo e(old('amount')); ?>" required
                               id="amount">
                    </div>
                </div>
                <div class="form-group">
                    <label for="recurring"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.recurring',1)); ?></label>
                    <div class="col-md-3">
                        <select name="recurring" class="form-control select2" id="recurring"
                                required>
                            <option value="0"><?php echo e(trans_choice('general.no',1)); ?></option>
                            <option value="1"><?php echo e(trans_choice('general.yes',1)); ?></option>
                        </select>
                    </div>
                </div>
                <div id="recur">
                    <div class="form-group">
                        <label for="recur_frequency"
                               class="control-label col-md-2"><?php echo e(trans_choice('general.recur',1)); ?> <?php echo e(trans_choice('general.frequency',1)); ?></label>
                        <div class="col-md-3">
                            <input type="number" name="recur_frequency" class="form-control"
                                   value="<?php echo e(old('recur_frequency')); ?>"
                                   id="recur_frequency">
                        </div>
                        <label for="recur_type"
                               class="control-label col-md-2"><?php echo e(trans_choice('general.recur',1)); ?> <?php echo e(trans_choice('general.type',1)); ?></label>
                        <div class="col-md-3">
                            <select name="recur_type" class="form-control select2" id="recur_type">
                                <option value="day"><?php echo e(trans_choice('general.day',1)); ?></option>
                                <option value="week"><?php echo e(trans_choice('general.week',1)); ?></option>
                                <option value="month"><?php echo e(trans_choice('general.month',1)); ?></option>
                                <option value="year"><?php echo e(trans_choice('general.year',1)); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="recur_start_date"
                               class="control-label col-md-2"><?php echo e(trans_choice('general.start',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></label>
                        <div class="col-md-3">
                            <input type="text" name="recur_start_date" class="form-control date-picker"
                                   value=""
                                   id="recur_start_date">
                        </div>
                        <label for="recur_end_date"
                               class="control-label col-md-2"><?php echo e(trans_choice('general.end',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></label>
                        <div class="col-md-3">
                            <input type="text" name="recur_end_date" class="form-control date-picker"
                                   value=""
                                   id="recur_end_date">
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="notes"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.note',2)); ?></label>
                    <div class="col-md-8">
                        <textarea name="notes" class="form-control "
                                  placeholder=""
                                  id="notes" rows="3"><?php echo e(old('notes')); ?></textarea>
                    </div>
                </div>
                <?php if(\App\Models\Setting::where('setting_key','enable_custom_fields')->first()->setting_value==1): ?>
                    <?php $__currentLoopData = \App\Models\CustomField::where('category','expenses')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="form-group">
                            <label for="notes"
                                   class="control-label col-md-2"><?php echo e($key->name); ?></label>
                            <div class="col-md-8">
                                <?php if($key->field_type=="number"): ?>
                                    <input type="number" class="form-control" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="textfield"): ?>
                                    <input type="text" class="form-control" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="date"): ?>
                                    <input type="text" class="form-control date-picker" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="textarea"): ?>
                                    <textarea class="form-control" name="custom_field_<?php echo e($key->id); ?>"
                                              <?php if($key->required==1): ?> required <?php endif; ?>></textarea>
                                <?php endif; ?>
                                <?php if($key->field_type=="decimal"): ?>
                                    <input type="text" class="form-control touchspin" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="select"): ?>
                                    <select class="form-control touchspin" name="custom_field_<?php echo e($key->id); ?>"
                                            <?php if($key->required==1): ?> required <?php endif; ?>>
                                        <?php if($key->required!=1): ?>
                                            <option value=""></option>
                                        <?php else: ?>
                                            <option value="" disabled selected>Select...</option>
                                        <?php endif; ?>
                                        <?php $__currentLoopData = explode(',',$key->select_values); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option><?php echo e($v); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                <?php endif; ?>
                                <?php if($key->field_type=="radiobox"): ?>
                                    <?php $__currentLoopData = explode(',',$key->radio_box_values); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="radio">
                                            <label>
                                                <input type="radio" name="custom_field_<?php echo e($key->id); ?>" id="<?php echo e($key->id); ?>"
                                                       value="<?php echo e($v); ?>"
                                                       <?php if($key->required==1): ?> required <?php endif; ?>>
                                                <b><?php echo e($v); ?></b>
                                            </label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                <?php if($key->field_type=="checkbox"): ?>
                                    <?php $__currentLoopData = explode(',',$key->checkbox_values); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="checkbox">
                                            <label>
                                                <input type="checkbox" name="custom_field_<?php echo e($key->id); ?>[<?php echo e($v); ?>]"
                                                       id="<?php echo e($key->id); ?>"
                                                       value="<?php echo e($v); ?>"
                                                       <?php if($key->required==1): ?> required <?php endif; ?>>
                                                <b><?php echo e($v); ?></b>
                                            </label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>

            <div class="box-footer">
                <button type="submit" class="btn btn-primary pull-right"><?php echo e(trans_choice('general.save',1)); ?></button>
            </div>
        </form>
    </div>
    <!-- /.box -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>

        $(document).ready(function (e) {
            $(".form-horizontal").validate();
            if ($('#recurring').val() == '1') {
                $('#recur').show();
                $('#recur_frequency').attr('required', 'required');
                $('#recur_start_date').attr('required', 'required');
                $('#recur_type').attr('required', 'required');
            } else {
                $('#recur').hide();
                $('#recur_frequency').removeAttr('required');
                $('#recur_start_date').removeAttr('required');
                $('#recur_type').removeAttr('required');
            }
            $('#recurring').change(function () {
                if ($('#recurring').val() == '1') {
                    $('#recur').show();
                    $('#recur_frequency').attr('required', 'required');
                    $('#recur_type').attr('required', 'required');
                    $('#recur_start_date').attr('required', 'required');
                } else {
                    $('#recur').hide();
                    $('#recur_frequency').removeAttr('required');
                    $('#recur_start_date').removeAttr('required');
                    $('#recur_type').removeAttr('required');
                }
            })
        })

    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ic026402/public_html/cres/resources/views/expense/create.blade.php ENDPATH**/ ?>