<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.group',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.group',1)); ?></h3>

            <div class="box-tools pull-right">
                <button onclick="window.history.back()" class="btn btn-info btn-sm">
                    <?php echo e(trans_choice('general.cancel',1)); ?>

                </button>
            </div>
        </div>
        <form method="post" action="<?php echo e(url('group/store')); ?>" class="form-horizontal" enctype="multipart/form-data">
            <?php echo e(csrf_field()); ?>

            <div class="box-body">
                <div class="form-group">
                    <label for="office_id"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.branch',1)); ?></label>
                    <div class="col-md-3">
                        <select name="office_id" class="form-control select2" id="office_id" required>
                            <option></option>
                            <?php $__currentLoopData = \App\Models\Office::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key->id); ?>"><?php echo e($key->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <label for="staff_id"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.staff',1)); ?></label>
                    <div class="col-md-3">
                        <select name="staff_id" class="form-control select2" id="staff_id" required>
                            <option></option>
                            <?php $__currentLoopData = \App\Models\User::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(!Sentinel::findUserById($key->id)->inRole('client')): ?>
                                    <option value="<?php echo e($key->id); ?>"><?php echo e($key->first_name); ?> <?php echo e($key->last_name); ?></option>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label for="name"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.name',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="name" class="form-control"
                               value="<?php echo e(old('name')); ?>"
                               required id="name">
                    </div>

                </div>
                <div class="form-group">
                    <label for="mobile"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.mobile',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="mobile" class="form-control"
                               value="<?php echo e(old('mobile')); ?>"
                               required id="mobile">
                    </div>
                    <label for="phone"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.phone',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="phone" class="form-control"
                               value="<?php echo e(old('phone')); ?>"
                               id="phone">
                    </div>
                </div>
                <div class="form-group">
                    <label for="email"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.email',1)); ?></label>
                    <div class="col-md-3">
                        <input type="email" name="email" class="form-control"
                               value="<?php echo e(old('email')); ?>"
                               id="email">
                    </div>
                </div>
                <div class="form-group">
                    <label for="street"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.street',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="street" class="form-control"
                               value="<?php echo e(old('street')); ?>"
                               id="street">
                    </div>
                    <label for="address"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.address',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="address" class="form-control"
                               value=""
                               id="address">
                    </div>

                </div>
                <div class="form-group">
                    <label for="clients"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.client',2)); ?></label>
                    <div class="col-md-3">
                        <select name="clients[]" class="form-control select2" id="clients" multiple required>
                            <?php $__currentLoopData = \App\Models\Client::where('status','active')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <option value="<?php echo e($key->id); ?>">
                                    <?php if($key->client_type=="individual"): ?>
                                        <?php echo e($key->first_name); ?> <?php echo e($key->middle_name); ?> <?php echo e($key->last_name); ?>

                                        (<?php echo e($key->account_no); ?>)
                                    <?php else: ?>
                                        <?php echo e($key->full_name); ?> (<?php echo e($key->account_no); ?>

                                        )
                                    <?php endif; ?>
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label for="external_id"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.external_id',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="external_id" class="form-control"
                               value="<?php echo e(old('external_id')); ?>"
                               id="external_id">
                    </div>
                    <label for="joined_date"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.registration',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="joined_date" class="form-control date-picker"
                               value="<?php echo e(date("Y-m-d")); ?>"
                               id="joined_date">
                    </div>

                </div>
                <div class="form-group">
                    <label for="notes"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.note',2)); ?></label>
                    <div class="col-md-8">
                        <textarea name="notes" class="form-control "
                                  placeholder=""
                                  id="notes" rows="3"><?php echo e(old('notes')); ?></textarea>
                    </div>


                </div>
                <?php if(\App\Models\Setting::where('setting_key','enable_custom_fields')->first()->setting_value==1): ?>
                    <?php $__currentLoopData = \App\Models\CustomField::where('category','groups')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="form-group">
                            <label for="notes"
                                   class="control-label col-md-2"><?php echo e($key->name); ?></label>
                            <div class="col-md-8">
                                <?php if($key->field_type=="number"): ?>
                                    <input type="number" class="form-control" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="textfield"): ?>
                                    <input type="text" class="form-control" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="date"): ?>
                                    <input type="text" class="form-control date-picker" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="textarea"): ?>
                                    <textarea class="form-control" name="custom_field_<?php echo e($key->id); ?>"
                                              <?php if($key->required==1): ?> required <?php endif; ?>></textarea>
                                <?php endif; ?>
                                <?php if($key->field_type=="decimal"): ?>
                                    <input type="text" class="form-control touchspin" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="select"): ?>
                                    <select class="form-control touchspin" name="custom_field_<?php echo e($key->id); ?>"
                                            <?php if($key->required==1): ?> required <?php endif; ?>>
                                        <?php if($key->required!=1): ?>
                                            <option value=""></option>
                                        <?php else: ?>
                                            <option value="" disabled selected>Select...</option>
                                        <?php endif; ?>
                                        <?php $__currentLoopData = explode(',',$key->select_values); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option><?php echo e($v); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                <?php endif; ?>
                                <?php if($key->field_type=="radiobox"): ?>
                                    <?php $__currentLoopData = explode(',',$key->radio_box_values); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="radio">
                                            <label>
                                                <input type="radio" name="custom_field_<?php echo e($key->id); ?>" id="<?php echo e($key->id); ?>" value="<?php echo e($v); ?>"
                                                       <?php if($key->required==1): ?> required <?php endif; ?>>
                                                <b><?php echo e($v); ?></b>
                                            </label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                <?php if($key->field_type=="checkbox"): ?>
                                    <?php $__currentLoopData = explode(',',$key->checkbox_values); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="checkbox">
                                            <label>
                                                <input type="checkbox" name="custom_field_<?php echo e($key->id); ?>[<?php echo e($v); ?>]" id="<?php echo e($key->id); ?>"
                                                       value="<?php echo e($v); ?>"
                                                       <?php if($key->required==1): ?> required <?php endif; ?>>
                                                <b><?php echo e($v); ?></b>
                                            </label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
            <!-- /.box-body -->
            <div class="box-footer">
                <div class="heading-elements">
                    <button type="submit" class="btn btn-primary pull-right"><?php echo e(trans_choice('general.save',1)); ?></button>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>
        $(".form-horizontal").validate({
            rules: {
                field: {
                    required: true,
                    step: 10
                }
            }, highlight: function (element) {
                $(element).closest('.form-group div').addClass('has-error');
            },
            unhighlight: function (element) {
                $(element).closest('.form-group div').removeClass('has-error');
            },
            errorElement: 'span',
            errorClass: 'help-block',
            errorPlacement: function (error, element) {
                if (element.parent('.input-group').length) {
                    error.insertAfter(element.parent());
                } else {
                    error.insertAfter(element);
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ic026402/public_html/cres/resources/views/group/create.blade.php ENDPATH**/ ?>