<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.loan',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.loan',1)); ?></h3>

            <div class="box-tools pull-right">
                <button onclick="window.history.back()" class="btn btn-info btn-sm">
                    <?php echo e(trans_choice('general.cancel',1)); ?>

                </button>
            </div>
        </div>
        <form method="post" action="<?php echo e(url('loan/create_client_loan/'.$client->id.'/'.$loan_product->id.'/store')); ?>"
              class="form-horizontal"
              enctype="multipart/form-data">
            <?php echo e(csrf_field()); ?>

            <div class="box-body">
                <div class="form-group">
                    <label for="loan_officer_id"
                           class="control-label col-md-2">
                        <?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.officer',1)); ?>

                        <i class="fa fa-question-circle" data-toggle="tooltip"
                           data-title="The financial institution representative who has responsibility for, and interacts with, the client/group associated with a loan account"></i>
                    </label>
                    <div class="col-md-3">
                        <select name="loan_officer_id" class="form-control select2" id="loan_officer_id" required>
                            <option></option>
                            <?php $__currentLoopData = \App\Models\User::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(!Sentinel::findUserById($key->id)->inRole('client')): ?>
                                    <option value="<?php echo e($key->id); ?>"
                                            <?php if($client->staff_id==$key->id): ?> selected <?php endif; ?>><?php echo e($key->first_name); ?> <?php echo e($key->last_name); ?></option>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <label for="loan_purpose_id"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.purpose',1)); ?>

                        <i class="fa fa-question-circle " data-toggle="tooltip"
                           data-title="Provides an indication of how the funds provided through the loan will be directed and can be used to group loans with the same purpose for reporting"></i>
                    </label>
                    <div class="col-md-3">
                        <select name="loan_purpose_id" class="form-control select2" id="loan_purpose_id">
                            <option></option>
                            <?php $__currentLoopData = \App\Models\LoanPurpose::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key->id); ?>"><?php echo e($key->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label for="fund_id"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.fund',1)); ?>

                        <i class="fa fa-question-circle " data-toggle="tooltip"
                           data-title="The original source of your funds (for example a grant)."></i>
                    </label>
                    <div class="col-md-3">
                        <select name="fund_id" class="form-control select2" id="fund_id">
                            <option></option>
                            <?php $__currentLoopData = \App\Models\GlAccount::where('active',1)->where('account_type',"asset")->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                             <option value="<?php echo e($key->id); ?>"><?php echo e($key->name); ?></option>
                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <label for="created_date"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.submitted',1)); ?> <?php echo e(trans_choice('general.on',1)); ?>

                        <i class="fa fa-question-circle " data-toggle="tooltip"
                           data-title="The date the loan account application was received"></i>
                    </label>
                    <div class="col-md-3">
                        <input type="text" name="created_date" class="form-control date-picker"
                               value="<?php echo e(date("Y-m-d")); ?>"
                               required id="created_date">
                    </div>
                </div>
                <div class="form-group">
                    <label for="external_id"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.external_id',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="external_id" class="form-control"
                               value="<?php echo e(old('external_id')); ?>"
                               id="external_id">
                    </div>
                </div>
                <div class="form-group">
                    <label for="principal"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.principal',1)); ?>

                    </label>
                    <div class="col-md-3">
                        <input type="number" name="principal" class="form-control"
                               min="<?php echo e($loan_product->minimum_principal); ?>" max="<?php echo e($loan_product->maximum_principal); ?>"
                               value="<?php echo e($loan_product->default_principal); ?>"
                               required id="principal">
                    </div>
                    <label for="loan_term"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.term',1)); ?>

                    </label>
                    <div class="col-md-2">
                        <input type="number" name="loan_term" class="form-control"
                               min="<?php echo e($loan_product->minimum_loan_term); ?>" max="<?php echo e($loan_product->maximum_loan_term); ?>"
                               value="<?php echo e($loan_product->default_loan_term); ?>"
                               required id="loan_term">
                    </div>
                    <div class="col-md-2">
                        <select name="loan_term_type" class="form-control " id="loan_term_type"
                                required>
                            <option value="days"
                                    <?php if($loan_product->repayment_frequency_type=="days"): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.day',2)); ?></option>
                            <option value="weeks"
                                    <?php if($loan_product->repayment_frequency_type=="weeks"): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.week',2)); ?></option>
                            <option value="months"
                                    <?php if($loan_product->repayment_frequency_type=="months"): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.month',2)); ?></option>
                            <option value="years"
                                    <?php if($loan_product->repayment_frequency_type=="years"): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.year',2)); ?></option>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label for="repayment_frequency"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.repayment',1)); ?>

                        <?php echo e(trans_choice('general.every',1)); ?>

                    </label>
                    <div class="col-md-2">
                        <input type="number" name="repayment_frequency" class="form-control" min="0"
                               value="<?php echo e($loan_product->repayment_frequency); ?>"
                               required id="repayment_frequency">
                    </div>
                    <div class="col-md-2">
                        <select name="repayment_frequency_type" class="form-control " id="repayment_frequency_type"
                                required>
                            <option value="days"
                                    <?php if($loan_product->repayment_frequency_type=="days"): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.day',2)); ?></option>
                            <option value="weeks"
                                    <?php if($loan_product->repayment_frequency_type=="weeks"): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.week',2)); ?></option>
                            <option value="months"
                                    <?php if($loan_product->repayment_frequency_type=="months"): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.month',2)); ?></option>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label for="override_interest"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.override',1)); ?> <?php echo e(trans_choice('general.interest',1)); ?>

                        <i class="fa fa-question-circle " data-toggle="tooltip"
                           data-title="Set yes if you want the system to use this interest per period for calculation"></i>
                    </label>
                    <div class="col-md-3">
                        <select name="override_interest" class="form-control select2" id="override_interest">
                            <option value="0"><?php echo e(trans_choice('general.no',1)); ?></option>
                            <option value="1"><?php echo e(trans_choice('general.yes',1)); ?></option>
                        </select>
                    </div>
                    <div id="override_interest_rate_div" style="display: none">
                        <label for="override_interest_rate"
                               class="control-label col-md-2"><?php echo e(trans_choice('general.override',1)); ?> <?php echo e(trans_choice('general.interest',1)); ?> <?php echo e(trans_choice('general.rate',1)); ?>

                        </label>
                        <div class="col-md-2">
                            <input type="number" name="override_interest_rate" class="form-control"
                                   value="<?php echo e($loan_product->default_interest_rate); ?>"
                                   id="override_interest_rate">
                        </div>
                    </div>
                </div>
                <div class="form-group" id="interest_rate_div">
                    <label for="interest_rate"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.interest',1)); ?> <?php echo e(trans_choice('general.rate',1)); ?>

                    </label>
                    <div class="col-md-2">
                        <input type="number" name="interest_rate" class="form-control"
                               min="<?php echo e($loan_product->minimum_interest_rate); ?>"
                               max="<?php echo e($loan_product->maximum_interest_rate); ?>"
                               value="<?php echo e($loan_product->default_interest_rate); ?>"
                               required id="interest_rate">
                    </div>
                    <label for="interest_rate_type"
                           class="control-label col-md-2 text-left">% <?php echo e(trans_choice('general.per',1)); ?>

                        <?php if($loan_product->interest_rate_type=="month"): ?>
                            <?php echo e(trans_choice('general.month',1)); ?>

                        <?php endif; ?>
                        <?php if($loan_product->interest_rate_type=="year"): ?>
                            <?php echo e(trans_choice('general.year',1)); ?>

                        <?php endif; ?>
                    </label>

                </div>
                <div class="form-group">
                    <label for="expected_disbursement_date"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.disbursement',1)); ?> <?php echo e(trans_choice('general.on',1)); ?>

                        <i class="fa fa-question-circle" data-toggle="tooltip"
                           data-title="The date that the loan account is expected to be disbursed"></i>
                    </label>
                    <div class="col-md-3">
                        <input type="text" name="expected_disbursement_date" class="form-control date-picker"
                               placeholder=""
                               required id="expected_disbursement_date">
                    </div>
                    <label for="expected_first_repayment_date"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.first',1)); ?> <?php echo e(trans_choice('general.repayment',1)); ?> <?php echo e(trans_choice('general.on',1)); ?>

                        <i class="fa fa-question-circle" data-toggle="tooltip"
                           data-title="May be entered to override the date the system would schedule"></i>
                    </label>
                    <div class="col-md-3">
                        <input type="text" name="expected_first_repayment_date" class="form-control date-picker"
                               placeholder="" required
                               id="expected_first_repayment_date">
                    </div>

                </div>

                <h3><?php echo e(trans_choice('general.charge',2)); ?></h3>
                <hr>
                <div class="form-group">
                    <label for="charges_dropdown"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.charge',1)); ?></label>
                    <div class="col-md-3">
                        <select name="charges_dropdown" class="form-control select2" id="charges_dropdown">
                            <option></option>
                            <?php $__currentLoopData = \App\Models\LoanProductCharge::where('loan_product_id',$loan_product->id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(!empty($key->charge)): ?>
                                    <?php if($key->charge->charge_type=="specified_due_date"): ?>
                                        <option value="<?php echo e($key->charge_id); ?>"><?php echo e($key->charge->name); ?></option>
                                    <?php endif; ?>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <button type="button" id="add_charge"
                                class="btn btn-info"><?php echo e(trans_choice('general.add',1)); ?></button>
                    </div>
                </div>
                <div class="row" id="charges_div">
                    <div class="col-md-12">
                        <div style="display: none;" id="saved_charges">
                        </div>
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th><?php echo e(trans_choice('general.name',1)); ?></th>
                                <th><?php echo e(trans_choice('general.type',1)); ?></th>
                                <th><?php echo e(trans_choice('general.amount',1)); ?></th>
                                <th><?php echo e(trans_choice('general.collected',1)); ?> <?php echo e(trans_choice('general.on',1)); ?></th>
                                <th><?php echo e(trans_choice('general.date',1)); ?></th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody id="charges_table">
                            <?php $__currentLoopData = $loan_product->charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(!empty($key->charge)): ?>
                                    <?php if($key->charge->charge_type=="disbursement" || $key->charge->charge_type=="installment_fee"): ?>
                                        <input type="hidden" name="charges[]" id="charge<?php echo e($key->charge_id); ?>"
                                               value="<?php echo e($key->charge_id); ?>">
                                        <tr id="row<?php echo e($key->charge->id); ?>">
                                            <td><?php echo e($key->charge->name); ?></td>
                                            <td>
                                                <?php if($key->charge->charge_option=="flat"): ?>
                                                    <?php echo e(trans_choice('general.flat',1)); ?>

                                                <?php endif; ?>
                                                <?php if($key->charge->charge_option=="installment_principal_due"): ?>
                                                    % <?php echo e(trans_choice('general.installment_principal_due',1)); ?>

                                                <?php endif; ?>
                                                <?php if($key->charge->charge_option=="installment_principal_interest_due"): ?>
                                                    % <?php echo e(trans_choice('general.installment_principal_interest_due',1)); ?>

                                                <?php endif; ?>
                                                <?php if($key->charge->charge_option=="installment_interest_due"): ?>
                                                    % <?php echo e(trans_choice('general.installment_interest_due',1)); ?>

                                                <?php endif; ?>
                                                <?php if($key->charge->charge_option=="total_due"): ?>
                                                    % <?php echo e(trans_choice('general.total_due',1)); ?>

                                                <?php endif; ?>
                                                <?php if($key->charge->charge_option=="original_principal"): ?>
                                                    % <?php echo e(trans_choice('general.original_principal',1)); ?>

                                                <?php endif; ?>
                                                <?php if($key->charge->charge_option=="percentage"): ?>
                                                    % <?php echo e(trans_choice('general.percentage',1)); ?> <?php echo e(trans_choice('general.of',1)); ?> <?php echo e(trans_choice('general.amount',1)); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($key->charge->override==1): ?>
                                                    <input type="number" class="form-control"
                                                           name="charge_amount[<?php echo e($key->charge->id); ?>]"
                                                           value="<?php echo e($key->charge->amount); ?>" required>
                                                <?php else: ?>
                                                    <input type="hidden" class="form-control"
                                                           name="charge_amount[<?php echo e($key->charge->id); ?>]"
                                                           value="<?php echo e($key->charge->amount); ?>">
                                                    <?php echo e($key->charge->amount); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($key->charge->charge_type=='disbursement'): ?>
                                                    <?php echo e(trans_choice('general.disbursement',1)); ?>

                                                <?php endif; ?>
                                                <?php if($key->charge->charge_type=='specified_due_date'): ?>
                                                    <?php echo e(trans_choice('general.specified_due_date',2)); ?>

                                                <?php endif; ?>
                                                <?php if($key->charge->charge_type=='installment_fee'): ?>
                                                    <?php echo e(trans_choice('general.installment_fee',2)); ?>

                                                <?php endif; ?>
                                                <?php if($key->charge->charge_type=='overdue_installment_fee'): ?>
                                                    <?php echo e(trans_choice('general.overdue_installment_fee',2)); ?>

                                                <?php endif; ?>
                                                <?php if($key->charge->charge_type=='loan_rescheduling_fee'): ?>
                                                    <?php echo e(trans_choice('general.loan_rescheduling_fee',2)); ?>

                                                <?php endif; ?>
                                                <?php if($key->charge->charge_type=='overdue_maturity'): ?>
                                                    <?php echo e(trans_choice('general.overdue_maturity',2)); ?>

                                                <?php endif; ?>
                                                <?php if($key->charge->charge_type=='savings_activation'): ?>
                                                    <?php echo e(trans_choice('general.savings_activation',2)); ?>

                                                <?php endif; ?>
                                                <?php if($key->charge->charge_type=='withdrawal_fee'): ?>
                                                    <?php echo e(trans_choice('general.withdrawal_fee',2)); ?>

                                                <?php endif; ?>
                                                <?php if($key->charge->charge_type=='monthly_fee'): ?>
                                                    <?php echo e(trans_choice('general.monthly_fee',2)); ?>

                                                <?php endif; ?>
                                                <?php if($key->charge->charge_type=='annual_fee'): ?>
                                                    <?php echo e(trans_choice('general.annual_fee',2)); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($key->charge->charge_type=='specified_due_date'): ?>
                                                    <input type="text" class="form-control date-picker"
                                                           name="charge_date[<?php echo e($key->charge->id); ?>]"
                                                           value="">
                                                <?php else: ?>
                                                    <input type="hidden" class="form-control"
                                                           name="charge_date[<?php echo e($key->charge->id); ?>]"
                                                           value="">
                                                <?php endif; ?>
                                            </td>
                                            <td></td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if(\App\Models\Setting::where('setting_key','enable_custom_fields')->first()->setting_value==1): ?>
                    <?php $__currentLoopData = \App\Models\CustomField::where('category','loans')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="form-group">
                            <label for="notes"
                                   class="control-label col-md-2"><?php echo e($key->name); ?></label>
                            <div class="col-md-8">
                                <?php if($key->field_type=="number"): ?>
                                    <input type="number" class="form-control" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="textfield"): ?>
                                    <input type="text" class="form-control" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="date"): ?>
                                    <input type="text" class="form-control date-picker" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="textarea"): ?>
                                    <textarea class="form-control" name="custom_field_<?php echo e($key->id); ?>"
                                              <?php if($key->required==1): ?> required <?php endif; ?>></textarea>
                                <?php endif; ?>
                                <?php if($key->field_type=="decimal"): ?>
                                    <input type="text" class="form-control touchspin" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="select"): ?>
                                    <select class="form-control touchspin" name="custom_field_<?php echo e($key->id); ?>"
                                            <?php if($key->required==1): ?> required <?php endif; ?>>
                                        <?php if($key->required!=1): ?>
                                            <option value=""></option>
                                        <?php else: ?>
                                            <option value="" disabled selected>Select...</option>
                                        <?php endif; ?>
                                        <?php $__currentLoopData = explode(',',$key->select_values); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option><?php echo e($v); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                <?php endif; ?>
                                <?php if($key->field_type=="radiobox"): ?>
                                    <?php $__currentLoopData = explode(',',$key->radio_box_values); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="radio">
                                            <label>
                                                <input type="radio" name="custom_field_<?php echo e($key->id); ?>" id="<?php echo e($key->id); ?>"
                                                       value="<?php echo e($v); ?>"
                                                       <?php if($key->required==1): ?> required <?php endif; ?>>
                                                <b><?php echo e($v); ?></b>
                                            </label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                <?php if($key->field_type=="checkbox"): ?>
                                    <?php $__currentLoopData = explode(',',$key->checkbox_values); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="checkbox">
                                            <label>
                                                <input type="checkbox" name="custom_field_<?php echo e($key->id); ?>[<?php echo e($v); ?>]"
                                                       id="<?php echo e($key->id); ?>"
                                                       value="<?php echo e($v); ?>"
                                                       <?php if($key->required==1): ?> required <?php endif; ?>>
                                                <b><?php echo e($v); ?></b>
                                            </label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
            <!-- /.box-body -->
            <div class="box-footer">
                <div class="heading-elements">
                    <button type="submit" class="btn btn-primary pull-right"><?php echo e(trans_choice('general.save',1)); ?></button>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>
        $('#currency_id').change(function (e) {
            var id = $('#currency_id').val();
            var url = "<?php echo url('loan/product'); ?>/" + id + "/get_currency_charges";
            var items = "";
            items += "<option></option>";
            $.getJSON(url, function (data) {
                $.each(data, function (index, item) {
                    items += "<option value='" + item.id + "'>" + item.name + "</option>";
                });
                $("#charges_dropdown").html(items);
            });
        });
        $('#add_charge').click(function (e) {
            if ($('#charges_dropdown').val() == "") {
                alert("Please select an item")
            } else {
                //try to build table
                var id = $('#charges_dropdown').val();
                $.ajax({
                    type: 'GET',
                    url: "<?php echo e(url('loan/product/')); ?>" + "/" + id + "/get_charge_detail",
                    dataType: "json",
                    success: function (data) {
                        var to_append = '<tr id="row' + id + '"><td>' + data.name + '</td><td>' + data.charge_option + '</td>';
                        if (data.override == "1") {
                            to_append = to_append + '<td> <input type="number" class="form-control" name="charge_amount[' + data.id + ']" value="' + data.amount + '" required></td>';
                        } else {
                            to_append = to_append + '<td> <input type="hidden" class="form-control" name="charge_amount[' + data.id + ']" value="' + data.amount + '" >' + data.amount + '</td>';
                        }
                        to_append = to_append + '<td>' + data.collected_on + '</td>';

                        to_append = to_append + '<td> <input type="text" class="form-control date-picker" name="charge_date[' + data.id + ']" value="" required></td>';
                        to_append = to_append + '<td><button type="button" class="btn btn-danger btn-xs" data-id="' + id + '" onclick="delete_charge(this)"><i class="fa fa-trash"></i></button></td>';
                        $('#charges_table').append(to_append);
                        $('#saved_charges').append('<input name="charges[]" id="charge' + id + '" value="' + id + '">');
                    },
                    error: function (data) {
                        swal({
                            title: 'Error',
                            text: 'An Error occurred, please try again',
                            type: 'warning',
                            showCancelButton: false,
                            confirmButtonColor: '#3085d6',
                            cancelButtonColor: '#d33',
                            confirmButtonText: 'Ok',
                            timer: 2000
                        })
                    }
                });
            }
        });
        function delete_charge(e) {
            swal({
                title: 'Are you sure?',
                text: '',
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ok',
                cancelButtonText: 'Cancel'
            }).then(function () {
                $('#charge' + $(e).attr("data-id")).remove();
                $('#row' + $(e).attr("data-id")).remove();

            })
        }
        if ($("#override_interest").val() == 0) {
            $("#override_interest_rate_div").hide();
            $("#interest_rate_div").show();
            $("#override_interest_rate").removeAttr("required");
            $("#interest_rate").attr("required","required");
        }else{
            $("#override_interest_rate_div").show();
            $("#override_interest_rate").attr("required","required");
            $("#interest_rate").removeAttr("required");
            $("#interest_rate_div").hide();
        }
        $("#override_interest").change(function () {
            if ($("#override_interest").val() == 0) {
                $("#override_interest_rate_div").hide();
                $("#interest_rate_div").show();
                $("#override_interest_rate").removeAttr("required");
                $("#interest_rate").attr("required","required");
            }else{
                $("#override_interest_rate_div").show();
                $("#override_interest_rate").attr("required","required");
                $("#interest_rate").removeAttr("required");
                $("#interest_rate_div").hide();
            }
        })
        $(".form-horizontal").validate({
            rules: {
                field: {
                    required: true,
                    step: 10
                }
            }, highlight: function (element) {
                $(element).closest('.form-group div').addClass('has-error');
            },
            unhighlight: function (element) {
                $(element).closest('.form-group div').removeClass('has-error');
            },
            errorElement: 'span',
            errorClass: 'help-block',
            errorPlacement: function (error, element) {
                if (element.parent('.input-group').length) {
                    error.insertAfter(element.parent());
                } else {
                    error.insertAfter(element);
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\changa\Documents\Projects\bedford-main\bedford-main\resources\views/loan/create_client_loan.blade.php ENDPATH**/ ?>