<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.client',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.client',1)); ?></h3>

            <div class="box-tools pull-right">
                <button onclick="window.history.back()" class="btn btn-info btn-sm">
                    <?php echo e(trans_choice('general.cancel',1)); ?>

                </button>
            </div>
        </div>
        <form method="post" action="<?php echo e(url('client/store')); ?>" class="form-horizontal" enctype="multipart/form-data">
            <?php echo e(csrf_field()); ?>

            <div class="box-body">
                <div class="form-group">
                    <label for="office_id"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.branch',1)); ?></label>
                    <div class="col-md-3">
                        <select name="office_id" class="form-control select2" id="office_id" required>
                            <option></option>
                            <?php $__currentLoopData = \App\Models\Office::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key->id); ?>"><?php echo e($key->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <label for="staff_id"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.staff',1)); ?></label>
                    <div class="col-md-3">
                        <select name="staff_id" class="form-control select2" id="staff_id" required>
                            <option></option>
                            <?php $__currentLoopData = \App\Models\User::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(!Sentinel::findUserById($key->id)->inRole('client')): ?>
                                    <option value="<?php echo e($key->id); ?>"><?php echo e($key->first_name); ?> <?php echo e($key->last_name); ?></option>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label for="office_id"
                           class="control-label col-md-2">Photo</label>
                    <div class="col-md-3">
                        <input type="file" name="picture" class="form-control"
                               value=""
                               id="picture">
                    </div>
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                </div>
                <div class="form-group">
                    <label for="client_type"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.client',1)); ?> <?php echo e(trans_choice('general.type',1)); ?></label>
                    <div class="col-md-3">
                        <select name="client_type" class="form-control " id="client_type" required>
                            <option value="individual"><?php echo e(trans_choice('general.individual',1)); ?></option>
                            <option value="business"><?php echo e(trans_choice('general.business',1)); ?></option>
                        </select>
                    </div>
                </div>
                <div id="business_name_div" style="display: none">
                    <div class="form-group">
                        <label for="full_name"
                               class="control-label col-md-2"><?php echo e(trans_choice('general.name',1)); ?></label>
                        <div class="col-md-3">
                            <input type="text" name="full_name" class="form-control"
                                   value="<?php echo e(old('full_name')); ?>"
                                   required id="full_name">
                        </div>
                        <label for="incorporation_number"
                               class="control-label col-md-2"><?php echo e(trans_choice('general.incorporation_number',1)); ?></label>
                        <div class="col-md-3">
                            <input type="text" name="incorporation_number" class="form-control"
                                   value="<?php echo e(old('incorporation_number')); ?>" id="incorporation_number">
                        </div>
                    </div>
                </div>
                <div id="individual_name_div">
                    <div class="form-group">
                        <label for="first_name"
                               class="control-label col-md-2"><?php echo e(trans_choice('general.first_name',1)); ?></label>
                        <div class="col-md-3">
                            <input type="text" name="first_name" class="form-control"
                                   value="<?php echo e(old('first_name')); ?>"
                                   required id="first_name">
                        </div>

                    </div>
                    <div class="form-group">
                        <label for="middle_name"
                               class="control-label col-md-2"><?php echo e(trans_choice('general.middle_name',1)); ?></label>
                        <div class="col-md-3">
                            <input type="text" name="middle_name" class="form-control"
                                   value="<?php echo e(old('middle_name')); ?>" id="middle_name">
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="last_name"
                               class="control-label col-md-2"><?php echo e(trans_choice('general.last_name',1)); ?></label>
                        <div class="col-md-3">
                            <input type="text" name="last_name" class="form-control"
                                   value="<?php echo e(old('last_name')); ?>"
                                   required id="last_name">
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="mobile"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.mobile',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="mobile" class="form-control"
                               value="<?php echo e(old('mobile')); ?>"
                               required id="mobile">
                    </div>
                    <label for="phone"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.phone',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="phone" class="form-control"
                               value="<?php echo e(old('phone')); ?>"
                               id="phone">
                    </div>
                </div>
                <div class="form-group">
                    <label for="email"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.email',1)); ?></label>
                    <div class="col-md-3">
                        <input type="email" name="email" class="form-control"
                               value="<?php echo e(old('email')); ?>"
                               id="email">
                    </div>
                </div>
                <div id="individual_extra_details">
                    <div class="form-group">
                        <label for="dob2" class="control-label col-md-2"><?php echo e(trans_choice('general.dob',1)); ?></label>
                        <div class="col-md-3">
                            <input type="text" name="dob2" class="form-control date-picker" value="<?php echo e(date("Y-m-d")); ?>" id="dob2">
                        </div>
                    </div>


                    <div class="form-group">
                        <label for="gender"
                               class="control-label col-md-2"><?php echo e(trans_choice('general.gender',1)); ?></label>
                        <div class="col-md-3">
                            <select name="gender" class="form-control" id="gender">
                                <option></option>
                                <option value="male"><?php echo e(trans('general.male')); ?></option>
                                <option value="female"><?php echo e(trans('general.female')); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="marital_status"
                               class="control-label col-md-2"><?php echo e(trans_choice('general.marital_status',1)); ?></label>
                        <div class="col-md-3">
                            <select name="marital_status" class="form-control" id="marital_status">
                                <option></option>
                                <option value="married"><?php echo e(trans('general.married')); ?></option>
                                <option value="single"><?php echo e(trans('general.single')); ?></option>
                                <option value="divorced"><?php echo e(trans('general.divorced')); ?></option>
                                <option value="widowed"><?php echo e(trans('general.widowed')); ?></option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="street"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.street',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="street" class="form-control"
                               value="<?php echo e(old('street')); ?>"
                               id="street">
                    </div>
                    <label for="address"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.address',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="address" class="form-control"
                               value=""
                               id="address">
                    </div>

                </div>
                <div class="form-group">
                    <label for="external_id"
                           class="control-label col-md-2">NRC Number</label>
                    <div class="col-md-3">
                        <input type="text" name="external_id" class="form-control"
                               value="<?php echo e(old('external_id')); ?>"
                               id="external_id">
                    </div>


                </div>
                <div class="form-group">
                    <label for="working_place"
                           class="control-label col-md-2">Working Place</label>
                    <div class="col-md-3">
                        <input type="text" name="working_place" class="form-control"
                               value="<?php echo e(old('working_place')); ?>"
                               id="working_place">
                    </div>

                    <label for="salary"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.net',1)); ?> <?php echo e(trans_choice('general.pay',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="salary" class="form-control"
                               value="<?php echo e(old('salary')); ?>"
                               id="salary">
                    </div>

                </div>
                <div class="form-group">
                    <label for="p"
                           class="control-label col-md-2">Position</label>
                    <div class="col-md-3">
                        <input type="text" name="working_position" class="form-control"
                               value="<?php echo e(old('working_position')); ?>"
                               id="working_position">
                    </div>

                    <label for="joined_date"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.registration',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="joined_date" class="form-control date-picker"
                               value="<?php echo e(date("Y-m-d")); ?>"
                               id="joined_date">
                    </div>

                </div>
                <div class="form-group">
                    <label for="notes"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.note',2)); ?></label>
                    <div class="col-md-8">
                        <textarea name="notes" class="form-control "
                                  placeholder=""
                                  id="notes" rows="3"><?php echo e(old('notes')); ?></textarea>
                    </div>
                </div>
                <?php if(\App\Models\Setting::where('setting_key','enable_custom_fields')->first()->setting_value==1): ?>
                    <?php $__currentLoopData = \App\Models\CustomField::where('category','clients')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="form-group">
                            <label for="notes"
                                   class="control-label col-md-2"><?php echo e($key->name); ?></label>
                            <div class="col-md-8">
                                <?php if($key->field_type=="number"): ?>
                                    <input type="number" class="form-control" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="textfield"): ?>
                                    <input type="text" class="form-control" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="date"): ?>
                                    <input type="text" class="form-control date-picker" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="textarea"): ?>
                                    <textarea class="form-control" name="custom_field_<?php echo e($key->id); ?>"
                                              <?php if($key->required==1): ?> required <?php endif; ?>></textarea>
                                <?php endif; ?>
                                <?php if($key->field_type=="decimal"): ?>
                                    <input type="text" class="form-control touchspin" name="custom_field_<?php echo e($key->id); ?>"
                                           <?php if($key->required==1): ?> required <?php endif; ?>>
                                <?php endif; ?>
                                <?php if($key->field_type=="select"): ?>
                                    <select class="form-control touchspin" name="custom_field_<?php echo e($key->id); ?>"
                                            <?php if($key->required==1): ?> required <?php endif; ?>>
                                        <?php if($key->required!=1): ?>
                                            <option value=""></option>
                                        <?php else: ?>
                                            <option value="" disabled selected>Select...</option>
                                        <?php endif; ?>
                                        <?php $__currentLoopData = explode(',',$key->select_values); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option><?php echo e($v); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                <?php endif; ?>
                                <?php if($key->field_type=="radiobox"): ?>
                                    <?php $__currentLoopData = explode(',',$key->radio_box_values); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="radio">
                                            <label>
                                                <input type="radio" name="custom_field_<?php echo e($key->id); ?>" id="<?php echo e($key->id); ?>"
                                                       value="<?php echo e($v); ?>"
                                                       <?php if($key->required==1): ?> required <?php endif; ?>>
                                                <b><?php echo e($v); ?></b>
                                            </label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                <?php if($key->field_type=="checkbox"): ?>
                                    <?php $__currentLoopData = explode(',',$key->checkbox_values); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="checkbox">
                                            <label>
                                                <input type="checkbox" name="custom_field_<?php echo e($key->id); ?>[<?php echo e($v); ?>]"
                                                       id="<?php echo e($key->id); ?>"
                                                       value="<?php echo e($v); ?>"
                                                       <?php if($key->required==1): ?> required <?php endif; ?>>
                                                <b><?php echo e($v); ?></b>
                                            </label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
            <!-- /.box-body -->
            <div class="box-footer">
                <div class="heading-elements">
                    <button type="submit" class="btn btn-primary pull-right"><?php echo e(trans_choice('general.save',1)); ?></button>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>
        if ($("#client_type").val() == "individual") {
            $("#business_name_div").hide();
            $("#individual_name_div").show();
            $("#individual_extra_details").show();
            $("#first_name").attr("required", "required");
            $("#last_name").attr("required", "required");
            $("#dob").attr("required", "required");
            $("#gender").attr("required", "required");
            $("#marital_status").attr("required", "required");
            $("#full_name").removeAttr("required");


        } else {
            $("#business_name_div").show();
            $("#individual_name_div").hide();
            $("#individual_extra_details").hide();
            $("#first_name").removeAttr("required");
            $("#last_name").removeAttr("required");
            $("#dob").removeAttr("required");
            $("#gender").removeAttr("required");
            $("#marital_status").removeAttr("required");
            $("#full_name").attr("required", "required");
        }
        $("#client_type").change(function () {
            if ($("#client_type").val() == "individual") {
                $("#business_name_div").hide();
                $("#individual_name_div").show();
                $("#individual_extra_details").show();
                $("#first_name").attr("required", "required");
                $("#last_name").attr("required", "required");
                $("#dob").attr("required", "required");
                $("#gender").attr("required", "required");
                $("#marital_status").attr("required", "required");
                $("#full_name").removeAttr("required");


            } else {
                $("#business_name_div").show();
                $("#individual_name_div").hide();
                $("#individual_extra_details").hide();
                $("#first_name").removeAttr("required");
                $("#last_name").removeAttr("required");
                $("#dob").removeAttr("required");
                $("#gender").removeAttr("required");
                $("#marital_status").removeAttr("required");
                $("#full_name").attr("required", "required");
            }
        });
        $(".form-horizontal").validate({
            rules: {
                field: {
                    required: true,
                    step: 10
                }
            }, highlight: function (element) {
                $(element).closest('.form-group div').addClass('has-error');
            },
            unhighlight: function (element) {
                $(element).closest('.form-group div').removeClass('has-error');
            },
            errorElement: 'span',
            errorClass: 'help-block',
            errorPlacement: function (error, element) {
                if (element.parent('.input-group').length) {
                    error.insertAfter(element.parent());
                } else {
                    error.insertAfter(element);
                }
            }
        });

        var date = $('#dob').datepicker({dateFormat: 'dd-mm-yy'}).val();
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ic026402/public_html/cres/resources/views/client/create.blade.php ENDPATH**/ ?>