<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.chart_of_account',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title"> <?php echo e(trans_choice('general.chart_of_account',2)); ?></h3>

            <div class="box-tools pull-right">
                <?php if(Sentinel::hasAccess('accounting.gl_accounts.create')): ?>
                    <a href="<?php echo e(url('accounting/gl_account/create')); ?>"
                       class="btn btn-info btn-sm"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.account',1)); ?></a>
                <?php endif; ?>
            </div>
        </div>
        <div class="box-body ">
            <div class="table-responsive">
                <table id="data-table" class="table table-striped table-condensed table-hover">
                    <thead>
                    <tr>
                        <th><?php echo e(trans_choice('general.gl_code',1)); ?></th>
                        <th><?php echo e(trans_choice('general.name',1)); ?></th>
                        <th><?php echo e(trans_choice('general.type',1)); ?></th>
                        <th><?php echo e(trans_choice('general.balance',1)); ?></th>
                        <th><?php echo e(trans_choice('general.unreconciled',1)); ?> <?php echo e(trans_choice('general.balance',1)); ?></th>
                        <th><?php echo e(trans_choice('general.note',2)); ?></th>
                        <th><?php echo e(trans_choice('general.action',1)); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key->gl_code); ?></td>
                            <td><?php echo e($key->name); ?></td>
                            <td>
                                <?php if($key->account_type=="expense"): ?>
                                    <?php echo e(trans_choice('general.expense',1)); ?>

                                <?php endif; ?>
                                <?php if($key->account_type=="asset"): ?>
                                    <?php echo e(trans_choice('general.asset',1)); ?>

                                <?php endif; ?>
                                <?php if($key->account_type=="equity"): ?>
                                    <?php echo e(trans_choice('general.equity',1)); ?>

                                <?php endif; ?>
                                <?php if($key->account_type=="liability"): ?>
                                    <?php echo e(trans_choice('general.liability',1)); ?>

                                <?php endif; ?>
                                <?php if($key->account_type=="income"): ?>
                                    <?php echo e(trans_choice('general.income',1)); ?>

                                <?php endif; ?>
                            </td>
                            <td>
                                <?php
                                $transactions = \App\Helpers\GeneralHelper::gl_account_balance($key->id);
                                $unreconciled_transactions = \App\Helpers\GeneralHelper::gl_account_unreconciled_balance($key->id);
                                $balance = 0;
                                $unreconciled_balance = 0;
                                if (!empty($transactions)) {
                                    if ($key->account_type == "asset" || $key->account_type == "expense") {
                                        $balance = $transactions->debit - $transactions->credit;
                                    }
                                    if ($key->account_type == "liability" || $key->account_type == "income" || $key->account_type == "equity") {
                                        $balance = $transactions->credit - $transactions->debit;
                                    }
                                }
                                if (!empty($unreconciled_transactions)) {
                                    if ($key->account_type == "asset" || $key->account_type == "expense") {
                                        $unreconciled_balance = $unreconciled_transactions->debit - $unreconciled_transactions->credit;
                                    }
                                    if ($key->account_type == "liability" || $key->account_type == "income" || $key->account_type == "equity") {
                                        $unreconciled_balance = $unreconciled_transactions->credit - $unreconciled_transactions->debit;
                                    }
                                }
                                ?>
                                <?php echo e(number_format($balance,2)); ?>

                            </td>
                            <td><?php echo e(number_format($unreconciled_balance,2)); ?></td>
                            <td><?php echo $key->notes; ?></td>
                            <td>
                                <div class="btn-group">
                                    <button class="btn btn-info btn-sm dropdown-toggle" type="button"
                                            data-toggle="dropdown"
                                            aria-expanded="false"><i
                                                class="fa fa-navicon"></i></button>
                                    <ul class="dropdown-menu dropdown-menu-right" role="menu">
                                        <?php if(Sentinel::hasAccess('accounting.gl_accounts.update')): ?>
                                            <li>
                                                <a href="<?php echo e(url('accounting/gl_account/'.$key->id.'/edit')); ?>"><i
                                                            class="fa fa-edit"></i>
                                                    <?php echo e(trans('general.edit')); ?></a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if(Sentinel::hasAccess('accounting.gl_accounts.delete')): ?>
                                            <li>
                                                <a href="<?php echo e(url('accounting/gl_account/'.$key->id.'/delete')); ?>"
                                                   class="delete"><i
                                                            class="fa fa-trash"></i>
                                                    <?php echo e(trans('general.delete')); ?></a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.box-body -->
    </div>
    <!-- /.box -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>
        $('#data-table').DataTable({
            "order": [[0, "asc"]],
            "columnDefs": [
                {"orderable": false, "targets": [4]}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ic026402/public_html/cres/resources/views/gl_account/data.blade.php ENDPATH**/ ?>