<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.awaiting',1)); ?> <?php echo e(trans_choice('general.disbursement',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title"><?php echo e(trans_choice('general.awaiting',1)); ?> <?php echo e(trans_choice('general.disbursement',1)); ?></h3>

            <div class="box-tools pull-right">
                <?php if(Sentinel::hasAccess('loans.create')): ?>
                    <a href="<?php echo e(url('loan/create')); ?>" class="btn btn-info btn-sm">
                        <?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.loan',1)); ?>

                    </a>
                <?php endif; ?>
            </div>
        </div>
        <div class="box-body table-responsive">
            <table class="table  table-bordered table-hover table-striped" id="data-table">
                <thead>
                <tr>
                    <th><?php echo e(trans_choice('general.account',1)); ?>#</th>
                    <th><?php echo e(trans_choice('general.branch',1)); ?></th>
                    <th><?php echo e(trans_choice('general.client',1)); ?></th>
                    <th><?php echo e(trans_choice('general.approved',1)); ?> <?php echo e(trans_choice('general.amount',1)); ?></th>
                    <th><?php echo e(trans_choice('general.created_at',1)); ?></th>
                    <th><?php echo e(trans_choice('general.product',1)); ?></th>
                    <th><?php echo e(trans_choice('general.action',1)); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key->id); ?></td>
                        <td>
                            <?php if(!empty($key->office)): ?>
                                <?php echo e($key->office->name); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($key->client_type=="client"): ?>
                                <?php if(!empty($key->client)): ?>
                                    <?php if($key->client->client_type=="individual"): ?>
                                        <?php echo e($key->client->first_name); ?> <?php echo e($key->client->middle_name); ?> <?php echo e($key->client->last_name); ?>

                                    <?php else: ?>
                                        <?php echo e($key->client->full_name); ?>

                                    <?php endif; ?>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if($key->client_type=="group"): ?>
                                <?php echo e($key->group->name); ?>

                            <?php endif; ?>
                        </td>
                        <td><?php echo e(number_format($key->approved_amount,$key->decimals)); ?></td>
                        <td><?php echo e($key->created_date); ?></td>
                        <td>
                            <?php if(!empty($key->loan_product)): ?>
                                <?php echo e($key->loan_product->name); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="btn-group">
                                <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown"
                                        aria-expanded="false"><i
                                            class="fa fa-navicon"></i></button>
                                <ul class="dropdown-menu dropdown-menu-right" role="menu">
                                    <?php if(Sentinel::hasAccess('loans.view')): ?>
                                        <li>
                                            <a href="<?php echo e(url('loan/'.$key->id.'/show')); ?>"><i
                                                        class="fa fa-search"></i>
                                                <?php echo e(trans_choice('general.detail',2)); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($key->status=="pending"): ?>
                                        <?php if(Sentinel::hasAccess('loans.update')): ?>
                                            <li>
                                                <a href="<?php echo e(url('loan/'.$key->id.'/edit')); ?>"><i
                                                            class="fa fa-edit"></i>
                                                    <?php echo e(trans('general.edit')); ?></a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if(Sentinel::hasAccess('loans.delete')): ?>
                                            <li>
                                                <a href="<?php echo e(url('loan/'.$key->id.'/delete')); ?>"
                                                   class="delete"><i
                                                            class="fa fa-trash"></i>
                                                    <?php echo e(trans('general.delete')); ?></a>
                                            </li>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>

        $('#data-table').DataTable({
            dom: 'frtip',
            "paging": true,
            "lengthChange": true,
            "displayLength": 15,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": true,
            "order": [[4, "desc"]],
            "columnDefs": [
                {"orderable": false, "targets": []}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\bedford-main\resources\views/loan/awaiting_disbursement.blade.php ENDPATH**/ ?>