<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.detail',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="panel ">
                <div class="panel-heading">
                    <h6 class="panel-title"><?php echo e($loan->loan_product->name); ?>(#<?php echo e($loan->id); ?>)</h6>

                    <div class="heading-elements">

                    </div>
                </div>
                <div class="panel-body">
                    <?php if($loan->status=="pending"): ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="pull-right btn-group">
                                    <?php if(Sentinel::hasAccess('loans.approve')): ?>
                                        <a href="#" data-toggle="modal" data-target="#approve_loan_modal"
                                           class="btn btn-primary"><i
                                                    class="fa fa-check"></i>&nbsp;<?php echo e(trans_choice('general.approve',1)); ?>

                                        </a>
                                        <a href="#" data-toggle="modal" data-target="#decline_loan_modal"
                                           class="btn btn-primary"><i
                                                    class="fa fa-times"></i>&nbsp;<?php echo e(trans_choice('general.decline',1)); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if(Sentinel::hasAccess('loans.update')): ?>
                                        <a href="<?php echo e(url('loan/'.$loan->id.'/edit')); ?>" class="btn btn-primary"><i
                                                    class="fa fa-edit"></i>&nbsp;<?php echo e(trans_choice('general.edit',1)); ?></a>
                                    <?php endif; ?>
                                    <button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown"
                                            aria-expanded="false">More<span class="caret"></span></button>
                                    <ul class="dropdown-menu dropdown-menu-right" role="menu">
                                        <?php if(Sentinel::hasAccess('loans.update')): ?>
                                            <li>
                                                <a href="#"
                                                   data-toggle="modal" data-target="#change_loan_officer_modal">
                                                    <?php echo e(trans_choice('general.change',1)); ?> <?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.officer',1)); ?></a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if(Sentinel::hasAccess('loans.approve')): ?>
                                            <li>
                                                <a href="#"
                                                   data-toggle="modal" data-target="#withdraw_loan_modal">
                                                    <?php echo e(trans('general.withdraw')); ?></a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if(Sentinel::hasAccess('loans.delete')): ?>
                                            <li>
                                                <a href="<?php echo e(url('loan/'.$loan->id.'/delete')); ?>"
                                                   class="delete">
                                                    <?php echo e(trans('general.delete')); ?></a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="row m-t-20" style="">
                            <div class="col-sm-7 col-md-7">
                                <table class="table table-striped table-bordered">
                                    <tbody>
                                    <?php if($loan->client_type=="client"): ?>
                                        <tr>
                                            <th class="table-bold-loan"><?php echo e(trans_choice('general.client',1)); ?></th>
                                            <td>
                                        <span class="padded-td">
                                             <?php if(!empty($loan->client)): ?>
                                                <?php if($loan->client->client_type=="individual"): ?>
                                                    <a href="<?php echo e(url('client/'.$loan->client_id.'/show')); ?>"><?php echo e($loan->client->first_name); ?> <?php echo e($loan->client->middle_name); ?> <?php echo e($loan->client->last_name); ?></a>
                                                    (<?php echo e(trans_choice('general.individual',1)); ?>)
                                                <?php else: ?>
                                                    <a href="<?php echo e(url('client/'.$loan->client_id.'/show')); ?>"><?php echo e($loan->client->full_name); ?></a>
                                                    (<?php echo e(trans_choice('general.business',1)); ?>)
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </span>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                    <?php if($loan->client_type=="group"): ?>
                                        <tr>
                                            <th class="table-bold-loan"><?php echo e(trans_choice('general.group',1)); ?></th>
                                            <td>
                                        <span class="padded-td">
                                             <?php if(!empty($loan->group)): ?>
                                                <a href="<?php echo e(url('group/'.$loan->group_id.'/show')); ?>"><?php echo e($loan->group->name); ?></a>
                                            <?php endif; ?>
                                        </span>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.currency',1)); ?></th>
                                        <td>
                                        <span class="padded-td">
                                              <?php if(!empty($loan->currency)): ?>
                                                <?php echo e($loan->currency->name); ?>

                                            <?php endif; ?>
                                        </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.officer',1)); ?></th>
                                        <td>
                                        <span class="padded-td">
                                              <?php if(!empty($loan->loan_officer)): ?>
                                                <?php echo e($loan->loan_officer->first_name); ?> <?php echo e($loan->loan_officer->last_name); ?>

                                            <?php endif; ?>
                                        </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.external_id',1)); ?> </th>
                                        <td>
                                            <span class="padded-td"><?php echo e($loan->external_id); ?></span>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-sm-5 col-md-5">
                                <table class="table table-striped table-bordered">
                                    <tbody>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.purpose',1)); ?></th>
                                        <td>
                                        <span class="padded-td">
                                              <?php if(!empty($loan->loan_purpose)): ?>
                                                <?php echo e($loan->loan_purpose->name); ?>

                                            <?php endif; ?>
                                        </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.proposed',1)); ?> <?php echo e(trans_choice('general.amount',1)); ?></th>
                                        <td>
                                            <span class="padded-td"><?php echo e(number_format($loan->principal,$loan->decimals)); ?></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.expected',1)); ?> <?php echo e(trans_choice('general.disbursement',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></th>
                                        <td>
                                            <span class="padded-td"><?php echo e($loan->expected_disbursement_date); ?></span>
                                        </td>
                                    </tr>

                                    </tbody>
                                </table>

                            </div>
                        </div>
                        <?php if(Sentinel::hasAccess('loans.approve')): ?>
                            <div class="modal fade" id="approve_loan_modal">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span></button>
                                            <h4 class="modal-title"><?php echo e(trans_choice('general.approve',1)); ?> <?php echo e(trans_choice('general.loan',1)); ?></h4>
                                        </div>
                                        <form method="post" action="<?php echo e(url('loan/'.$loan->id.'/approve')); ?>"
                                              class="form-horizontal "
                                              enctype="multipart/form-data" id="approve_loan_form">
                                            <?php echo e(csrf_field()); ?>

                                            <div class="modal-body">
                                                <div class="form-group">
                                                    <label for="approved_date"
                                                           class="control-label col-md-3"><?php echo e(trans_choice('general.approved',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></label>
                                                    <div class="col-md-9">
                                                        <input type="text" name="approved_date"
                                                               class="form-control date-picker"
                                                               value="<?php echo e(date("Y-m-d")); ?>"
                                                               required id="approved_date">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label for="approved_amount"
                                                           class="control-label col-md-3"><?php echo e(trans_choice('general.amount',1)); ?></label>
                                                    <div class="col-md-9">
                                                        <input type="number" name="approved_amount" class="form-control"
                                                               value="<?php echo e($loan->applied_amount); ?>"
                                                               required id="approved_amount">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label for="approved_notes"
                                                           class="control-label col-md-3"><?php echo e(trans_choice('general.note',2)); ?></label>
                                                    <div class="col-md-9">
                                                     <textarea name="approved_notes" class="form-control"
                                                               id="approved_notes"
                                                               rows="3"><?php echo e(old('approved_notes')); ?></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-default pull-left"
                                                        data-dismiss="modal"><?php echo e(trans_choice('general.close',1)); ?></button>
                                                <button type="submit"
                                                        class="btn btn-primary"><?php echo e(trans_choice('general.save',1)); ?></button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div class="modal fade" id="decline_loan_modal">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span></button>
                                            <h4 class="modal-title"><?php echo e(trans_choice('general.decline',1)); ?> <?php echo e(trans_choice('general.loan',1)); ?></h4>
                                        </div>
                                        <form method="post" action="<?php echo e(url('loan/'.$loan->id.'/decline')); ?>"
                                              class="form-horizontal "
                                              enctype="multipart/form-data" id="decline_loan_form">
                                            <?php echo e(csrf_field()); ?>

                                            <div class="modal-body">
                                                <div class="form-group">
                                                    <label for="declined_notes"
                                                           class="control-label col-md-3"><?php echo e(trans_choice('general.note',2)); ?></label>
                                                    <div class="col-md-9">
                                                     <textarea name="declined_notes" class="form-control"
                                                               id="declined_notes" rows="3"
                                                               required><?php echo e(old('declined_notes')); ?></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-default pull-left"
                                                        data-dismiss="modal"><?php echo e(trans_choice('general.close',1)); ?></button>
                                                <button type="submit"
                                                        class="btn btn-primary"><?php echo e(trans_choice('general.save',1)); ?></button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="modal fade" id="withdraw_loan_modal">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title"><?php echo e(trans_choice('general.withdraw',1)); ?> <?php echo e(trans_choice('general.loan',1)); ?></h4>
                                    </div>
                                    <form method="post" action="<?php echo e(url('loan/'.$loan->id.'/withdraw')); ?>"
                                          class="form-horizontal "
                                          enctype="multipart/form-data" id="withdraw_loan_form">
                                        <?php echo e(csrf_field()); ?>

                                        <div class="modal-body">
                                            <div class="form-group">
                                                <label for="withdrawn_notes"
                                                       class="control-label col-md-3"><?php echo e(trans_choice('general.note',2)); ?></label>
                                                <div class="col-md-9">
                                                     <textarea name="withdrawn_notes" class="form-control"
                                                               id="declined_notes" rows="3"
                                                               required><?php echo e(old('withdrawn_notes')); ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-default pull-left"
                                                    data-dismiss="modal"><?php echo e(trans_choice('general.close',1)); ?></button>
                                            <button type="submit"
                                                    class="btn btn-primary"><?php echo e(trans_choice('general.save',1)); ?></button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                    <?php endif; ?>
                    <?php if($loan->status=="approved"): ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="pull-right btn-group">
                                    <?php if(Sentinel::hasAccess('loans.disburse')): ?>
                                        <a href="#" data-toggle="modal" data-target="#disburse_loan_modal"
                                           class="btn btn-primary"><i
                                                    class="fa fa-flag"></i>&nbsp;<?php echo e(trans_choice('general.disburse',1)); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if(Sentinel::hasAccess('loans.undo_approval')): ?>
                                        <a href="<?php echo e(url('loan/'.$loan->id.'/unapprove')); ?>"
                                           class="btn btn-primary confirm"><i
                                                    class="fa fa-undo"></i>&nbsp;<?php echo e(trans_choice('general.undo',1)); ?>

                                            &nbsp;<?php echo e(trans_choice('general.approval',1)); ?></a>
                                    <?php endif; ?>
                                    <?php if(Sentinel::hasAccess('loans.update')): ?>
                                        <a href="#"
                                           data-toggle="modal" data-target="#change_loan_officer_modal"
                                           class="btn btn-primary"><i
                                                    class="fa fa-user"></i>&nbsp;
                                            <?php echo e(trans_choice('general.change',1)); ?> <?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.officer',1)); ?>

                                        </a>
                                    <?php endif; ?>
                                    <button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown"
                                            aria-expanded="false">More<span class="caret"></span></button>

                                </div>
                            </div>
                        </div>
                        <div class="row m-t-20" style="">
                            <div class="col-sm-7 col-md-7">
                                <table class="table table-striped table-bordered">
                                    <tbody>
                                    <?php if($loan->client_type=="client"): ?>
                                        <tr>
                                            <th class="table-bold-loan"><?php echo e(trans_choice('general.client',1)); ?></th>
                                            <td>
                                        <span class="padded-td">
                                             <?php if(!empty($loan->client)): ?>
                                                <?php if($loan->client->client_type=="individual"): ?>
                                                    <a href="<?php echo e(url('client/'.$loan->client_id.'/show')); ?>"><?php echo e($loan->client->first_name); ?> <?php echo e($loan->client->middle_name); ?> <?php echo e($loan->client->last_name); ?></a>
                                                    (<?php echo e(trans_choice('general.individual',1)); ?>)
                                                <?php else: ?>
                                                    <a href="<?php echo e(url('client/'.$loan->client_id.'/show')); ?>"><?php echo e($loan->client->full_name); ?></a>
                                                    (<?php echo e(trans_choice('general.business',1)); ?>)
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </span>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                    <?php if($loan->client_type=="group"): ?>
                                        <tr>
                                            <th class="table-bold-loan"><?php echo e(trans_choice('general.group',1)); ?></th>
                                            <td>
                                        <span class="padded-td">
                                             <?php if(!empty($loan->group)): ?>
                                                <a href="<?php echo e(url('group/'.$loan->group_id.'/show')); ?>"><?php echo e($loan->group->name); ?></a>
                                            <?php endif; ?>
                                        </span>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.currency',1)); ?></th>
                                        <td>
                                        <span class="padded-td">
                                              <?php if(!empty($loan->currency)): ?>
                                                <?php echo e($loan->currency->name); ?>

                                            <?php endif; ?>
                                        </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.officer',1)); ?></th>
                                        <td>
                                        <span class="padded-td">
                                              <?php if(!empty($loan->loan_officer)): ?>
                                                <?php echo e($loan->loan_officer->first_name); ?> <?php echo e($loan->loan_officer->last_name); ?>

                                            <?php endif; ?>
                                        </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.external_id',1)); ?> </th>
                                        <td>
                                            <span class="padded-td"><?php echo e($loan->external_id); ?></span>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-sm-5 col-md-5">
                                <table class="table table-striped table-bordered">
                                    <tbody>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.purpose',1)); ?></th>
                                        <td>
                                        <span class="padded-td">
                                              <?php if(!empty($loan->loan_purpose)): ?>
                                                <?php echo e($loan->loan_purpose->name); ?>

                                            <?php endif; ?>
                                        </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.proposed',1)); ?> <?php echo e(trans_choice('general.amount',1)); ?></th>
                                        <td>
                                            <span class="padded-td"><?php echo e(number_format($loan->applied_amount,$loan->decimals)); ?></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.approved',1)); ?> <?php echo e(trans_choice('general.amount',1)); ?></th>
                                        <td>
                                            <span class="padded-td"><?php echo e(number_format($loan->approved_amount,$loan->decimals)); ?></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.expected',1)); ?> <?php echo e(trans_choice('general.disbursement',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></th>
                                        <td>
                                            <span class="padded-td"><?php echo e($loan->expected_disbursement_date); ?></span>
                                        </td>
                                    </tr>

                                    </tbody>
                                </table>

                            </div>
                        </div>
                        <div class="modal fade" id="disburse_loan_modal">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title"><?php echo e(trans_choice('general.disburse',1)); ?> <?php echo e(trans_choice('general.loan',1)); ?></h4>
                                    </div>
                                    <form method="post" action="<?php echo e(url('loan/'.$loan->id.'/disburse')); ?>"
                                          class="form-horizontal "
                                          enctype="multipart/form-data" id="disburse_loan_form">
                                        <?php echo e(csrf_field()); ?>

                                        <div class="modal-body">
                                            <div class="form-group">
                                                <label for="disbursement_date"
                                                       class="control-label col-md-4"><?php echo e(trans_choice('general.disbursement',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></label>
                                                <div class="col-md-8">
                                                    <input type="text" name="disbursement_date"
                                                           class="form-control date-picker"
                                                           value="<?php echo e($loan->expected_disbursement_date); ?>"
                                                           required id="disbursement_date">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="first_repayment_date"
                                                       class="control-label col-md-4"><?php echo e(trans_choice('general.first',1)); ?> <?php echo e(trans_choice('general.repayment',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></label>
                                                <div class="col-md-8">
                                                    <input type="text" name="first_repayment_date"
                                                           class="form-control date-picker"
                                                           value="<?php echo e($loan->expected_first_repayment_date); ?>"
                                                           required id="first_repayment_date">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="payment_type_id"
                                                       class="control-label col-md-4"><?php echo e(trans_choice('general.payment',1)); ?> <?php echo e(trans_choice('general.type',1)); ?>

                                                </label>
                                                <div class="col-md-8">
                                                    <select name="payment_type_id" class="form-control select2"
                                                            id="payment_type_id" required>
                                                        <option></option>
                                                        <?php $__currentLoopData = \App\Models\PaymentType::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($key->id); ?>"><?php echo e($key->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>

                                       
                                            <div class="form-group">
                                                <label for="approved_amount"
                                                       class="control-label col-md-4"><?php echo e(trans_choice('general.show',1)); ?> <?php echo e(trans_choice('general.payment',1)); ?> <?php echo e(trans_choice('general.detail',2)); ?></label>
                                                <div class="col-md-8">
                                                    <button type="button" class="btn btn-primary" data-toggle="collapse"
                                                            data-target="#show_payment_details">
                                                        <i class="fa fa-plus"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <div id="show_payment_details" class="collapse">
                                                <div class="form-group">
                                                    <label for="account_number"
                                                           class="control-label col-md-4"><?php echo e(trans_choice('general.account',1)); ?>

                                                        #</label>
                                                    <div class="col-md-8">
                                                        <input type="text" name="account_number"
                                                               class="form-control"
                                                               value=""
                                                               id="account_number">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label for="cheque_number"
                                                           class="control-label col-md-4"><?php echo e(trans_choice('general.cheque',1)); ?>

                                                        #</label>
                                                    <div class="col-md-8">
                                                        <input type="text" name="cheque_number"
                                                               class="form-control"
                                                               value=""
                                                               id="cheque_number">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label for="routing_code"
                                                           class="control-label col-md-4"><?php echo e(trans_choice('general.routing_code',1)); ?></label>
                                                    <div class="col-md-8">
                                                        <input type="text" name="routing_code"
                                                               class="form-control"
                                                               value=""
                                                               id="routing_code">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label for="receipt_number"
                                                           class="control-label col-md-4"><?php echo e(trans_choice('general.receipt',1)); ?>

                                                        #</label>
                                                    <div class="col-md-8">
                                                        <input type="text" name="receipt_number"
                                                               class="form-control"
                                                               value=""
                                                               id="receipt_number">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label for="bank"
                                                           class="control-label col-md-4"><?php echo e(trans_choice('general.bank',1)); ?>

                                                        #</label>
                                                    <div class="col-md-8">
                                                        <input type="text" name="bank"
                                                               class="form-control"
                                                               value=""
                                                               id="bank">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="disbursed_notes"
                                                       class="control-label col-md-4"><?php echo e(trans_choice('general.note',2)); ?></label>
                                                <div class="col-md-8">
                                                     <textarea name="disbursed_notes" class="form-control"
                                                               id="disbursed_notes"
                                                               rows="3"><?php echo e(old('disbursed_notes')); ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-default pull-left"
                                                    data-dismiss="modal"><?php echo e(trans_choice('general.close',1)); ?></button>
                                            <button type="submit"
                                                    class="btn btn-primary"><?php echo e(trans_choice('general.save',1)); ?></button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                    <?php endif; ?>
                    <?php if($loan->status=="disbursed"): ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="pull-right btn-group">
                                    <?php if(Sentinel::hasAccess('loans.transactions.create')): ?>
                                        <a href="<?php echo e(url('loan/'.$loan->id.'/repayment/create')); ?>"
                                           class="btn btn-primary"><i
                                                    class="fa fa-dollar"></i>&nbsp;<?php echo e(trans_choice('general.make',1)); ?> <?php echo e(trans_choice('general.repayment',1)); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if(Sentinel::hasAccess('loans.charge.create')): ?>
                                        <a href="#"
                                           data-toggle="modal" data-target="#add_charge_modal"
                                           class="btn btn-primary"><i
                                                    class="fa fa-plus"></i>&nbsp;<?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.charge',1)); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if(Sentinel::hasAccess('loans.update')): ?>
                                        <a href="#"
                                           data-toggle="modal" data-target="#change_loan_officer_modal"
                                           class="btn btn-primary"><i
                                                    class="fa fa-user"></i>&nbsp;
                                            <?php echo e(trans_choice('general.change',1)); ?> <?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.officer',1)); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if(Sentinel::hasAccess('loans.undo_disbursement')): ?>
                                        <a href="<?php echo e(url('loan/'.$loan->id.'/undisburse')); ?>"
                                           class="btn btn-primary confirm"><i
                                                    class="fa fa-undo"></i>&nbsp;<?php echo e(trans_choice('general.undo',1)); ?>

                                            &nbsp;<?php echo e(trans_choice('general.disbursement',1)); ?></a>
                                    <?php endif; ?>
                                    <button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown"
                                            aria-expanded="false">More <span class="caret"></span></button>
                                    <ul class="dropdown-menu dropdown-menu-right" role="menu">
                                            <?php if(Sentinel::hasAccess('loans.pdf_schedule')): ?>
                                            <li>
                                                <a href="<?php echo e(url('loan/'.$loan->id.'/statement')); ?>"
                                                   target="_blank">
                                                    <?php echo e(trans_choice('general.account',1)); ?> <?php echo e(trans_choice('general.statement',1)); ?> </a>
                                            </li>
                                        <?php endif; ?>

                                        <?php if(Sentinel::hasAccess('loans.waive_interest')): ?>
                                            <li>
                                                <a href="#" data-toggle="modal" data-target="#waive_interest_modal">
                                                    <?php echo e(trans_choice('general.waive',1)); ?> <?php echo e(trans_choice('general.interest',1)); ?></a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if(Sentinel::hasAccess('loans.email_schedule')): ?>
                                            <li>
                                                <a href="<?php echo e(url('loan/'.$loan->id.'/email_schedule')); ?>" class="delete">
                                                    <?php echo e(trans_choice('general.email',1)); ?> <?php echo e(trans_choice('general.schedule',1)); ?> </a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if(Sentinel::hasAccess('loans.pdf_schedule')): ?>
                                            <li>
                                                <a href="<?php echo e(url('loan/'.$loan->id.'/pdf_schedule')); ?>" target="_blank">
                                                    <?php echo e(trans_choice('general.pdf',1)); ?> <?php echo e(trans_choice('general.schedule',1)); ?> </a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if(Sentinel::hasAccess('loans.pdf_schedule')): ?>
                                            <li>
                                                <a href="<?php echo e(url('loan/'.$loan->id.'/print_schedule')); ?>"
                                                   target="_blank">
                                                    <?php echo e(trans_choice('general.print',1)); ?> <?php echo e(trans_choice('general.schedule',1)); ?> </a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if(Sentinel::hasAccess('loans.write_off')): ?>
                                            <li>
                                                <a href="#" data-toggle="modal" data-target="#write_off_loan_modal">
                                                    <?php echo e(trans_choice('general.write_off',1)); ?> </a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if(Sentinel::hasAccess('loans.close')): ?>
                                            <li class="hidden">
                                                <a href="#" data-toggle="modal" data-target="#close_loan_modal">
                                                    <?php echo e(trans_choice('general.close',1)); ?> </a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="row m-t-20" style="">
                            <div class="col-sm-8 col-md-8">
                                <?php
                                $loan_allocation = \App\Helpers\GeneralHelper::loan_items($loan->id);
                                $decimals = $loan->loan_product->decimals;
                                $timely_repayments = 0;
                                $total_repayments = 0;
                                $days_in_arrears = 0;
                                $amount_in_arrears = 0;
                                $amount_due = 0;
                                $amount_paid = 0;
                                $late_count = 0;
                                foreach (\App\Models\LoanRepaymentSchedule::where('loan_id', $loan->id)->where('due_date', '<', date("Y-m-d"))->orderBy('due_date', 'asc')->get() as $schedule) {
                                    $total_repayments = $total_repayments + 1;
                                    $amount_in_arrears = $amount_in_arrears + (($schedule->principal - $schedule->principal_waived - $schedule->principal_written_off - $schedule->principal_paid) + ($schedule->interest - $schedule->interest_waived - $schedule->interest_written_off - $schedule->interest_paid) + ($schedule->fees - $schedule->fees_waived - $schedule->fees_written_off - $schedule->fees_paid) + ($schedule->penalty - $schedule->penalty_waived - $schedule->penalty_written_off - $schedule->penalty_paid));
                                    if (!empty($schedule->from_date)) {
                                        if (strtotime($schedule->due_date) > strtotime($schedule->from_date)) {
                                            $timely_repayments = $timely_repayments + 1;
                                        }
                                    }
                                    if ($amount_in_arrears > 0) {
                                        $late_count++;
                                        if ($late_count == 1) {
                                            $overdue_date = $schedule->due_date;
                                        }
                                    }

                                }
                                if ($amount_in_arrears > 0) {
                                    $date1 = new DateTime($overdue_date);
                                    $date2 = new DateTime(date("Y-m-d"));
                                    $days_in_arrears = $date2->diff($date1)->format("%a");
                                }
                                ?>
                                <h4 class=""><?php echo e(trans_choice('general.current',1)); ?> <?php echo e(trans_choice('general.balance',1)); ?>

                                    :
                                    <b><?php echo e(number_format(($loan_allocation["principal"]-$loan_allocation["principal_paid"]-$loan_allocation["principal_waived"]-$loan_allocation["principal_written_off"])+($loan_allocation["interest"]-$loan_allocation["interest_paid"]-$loan_allocation["interest_waived"]-$loan_allocation["interest_written_off"])+($loan_allocation["fees"]-$loan_allocation["fees_paid"]-$loan_allocation["fees_waived"]-$loan_allocation["fees_written_off"])+($loan_allocation["penalty"]-$loan_allocation["penalty_paid"]-$loan_allocation["penalty_waived"]-$loan_allocation["penalty_written_off"]),$decimals)); ?></b>
                                </h4>
                                <h4 class="">
                                    <?php echo e(trans_choice('general.timely',1)); ?> <?php echo e(trans_choice('general.repayment',2)); ?>:
                                    <?php if($total_repayments>0): ?>
                                        <b><?php echo e($timely_repayments*100/$total_repayments); ?>%</b>
                                    <?php else: ?>
                                        <b> 0%</b>
                                    <?php endif; ?>
                                </h4>
                                <h4 class="">
                                    <?php echo e(trans_choice('general.amount',1)); ?> <?php echo e(trans_choice('general.in',1)); ?> <?php echo e(trans_choice('general.arrears',1)); ?>

                                    :
                                    <b><?php echo e(number_format($amount_in_arrears,$decimals)); ?></b>
                                </h4>
                                <h4 class="">
                                    <?php echo e(trans_choice('general.day',2)); ?> <?php echo e(trans_choice('general.in',1)); ?> <?php echo e(trans_choice('general.arrears',1)); ?>

                                    :
                                    <b><?php echo e($days_in_arrears); ?></b>
                                </h4>
                                <table class="pretty displayschedule" id="summarytable">
                                    <thead>
                                    <tr>
                                        <th class="empty"></th>
                                        <th><?php echo e(trans_choice('general.contract',1)); ?></th>
                                        <th><?php echo e(trans_choice('general.paid',1)); ?></th>
                                        <th><?php echo e(trans_choice('general.waived',1)); ?></th>
                                        <th><?php echo e(trans_choice('general.written_off',1)); ?></th>
                                        <th><?php echo e(trans_choice('general.outstanding',1)); ?></th>
                                        <th><?php echo e(trans_choice('general.overdue',1)); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <th><?php echo e(trans_choice('general.principal',1)); ?></th>
                                        <td><?php echo e(number_format($loan_allocation["principal"],$decimals)); ?></td>
                                        <td><?php echo e(number_format($loan_allocation["principal_paid"],$decimals)); ?></td>
                                        <td><?php echo e(number_format($loan_allocation["principal_waived"],$decimals)); ?></td>
                                        <td><?php echo e(number_format($loan_allocation["principal_written_off"],$decimals)); ?></td>
                                        <td><?php echo e(number_format($loan_allocation["principal"]-$loan_allocation["principal_paid"]-$loan_allocation["principal_waived"]-$loan_allocation["principal_written_off"],$decimals)); ?></td>
                                        <td><?php echo e(number_format(0,$decimals)); ?></td>
                                    </tr>
                                    <tr>
                                        <th><?php echo e(trans_choice('general.interest',1)); ?></th>
                                        <td><?php echo e(number_format($loan_allocation["interest"],$decimals)); ?></td>
                                        <td><?php echo e(number_format($loan_allocation["interest_paid"],$decimals)); ?></td>
                                        <td><?php echo e(number_format($loan_allocation["interest_waived"],$decimals)); ?></td>
                                        <td><?php echo e(number_format($loan_allocation["interest_written_off"],$decimals)); ?></td>
                                        <td><?php echo e(number_format($loan_allocation["interest"]-$loan_allocation["interest_paid"]-$loan_allocation["interest_waived"]-$loan_allocation["interest_written_off"],$decimals)); ?></td>
                                        <td><?php echo e(number_format(0,$decimals)); ?></td>
                                    </tr>
                                    <tr>
                                        <th><?php echo e(trans_choice('general.fee',2)); ?></th>
                                        <td><?php echo e(number_format($loan_allocation["fees"],$decimals)); ?></td>
                                        <td><?php echo e(number_format($loan_allocation["fees_paid"],$decimals)); ?></td>
                                        <td><?php echo e(number_format($loan_allocation["fees_waived"],$decimals)); ?></td>
                                        <td><?php echo e(number_format($loan_allocation["fees_written_off"],$decimals)); ?></td>
                                        <td><?php echo e(number_format($loan_allocation["fees"]-$loan_allocation["fees_paid"]-$loan_allocation["fees_waived"]-$loan_allocation["fees_written_off"],$decimals)); ?></td>
                                        <td><?php echo e(number_format(0,$decimals)); ?></td>
                                    </tr>
                                    <tr>
                                        <th><?php echo e(trans_choice('general.penalty',1)); ?></th>
                                        <td><?php echo e(number_format($loan_allocation["penalty"],$decimals)); ?></td>
                                        <td><?php echo e(number_format($loan_allocation["penalty_paid"],$decimals)); ?></td>
                                        <td><?php echo e(number_format($loan_allocation["penalty_waived"],$decimals)); ?></td>
                                        <td><?php echo e(number_format($loan_allocation["penalty_written_off"],$decimals)); ?></td>
                                        <td><?php echo e(number_format($loan_allocation["penalty"]-$loan_allocation["penalty_paid"]-$loan_allocation["penalty_waived"]-$loan_allocation["penalty_written_off"],$decimals)); ?></td>
                                        <td><?php echo e(number_format(0,$decimals)); ?></td>
                                    </tr>
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <th><?php echo e(trans_choice('general.total',1)); ?></th>
                                        <th><?php echo e(number_format($loan_allocation["principal"]+$loan_allocation["interest"]+$loan_allocation["fees"]+$loan_allocation["penalty"],$decimals)); ?></th>
                                        <th><?php echo e(number_format($loan_allocation["principal_paid"]+$loan_allocation["interest_paid"]+$loan_allocation["fees_paid"]+$loan_allocation["penalty_paid"],$decimals)); ?></th>
                                        <th><?php echo e(number_format($loan_allocation["principal_waived"]+$loan_allocation["interest_waived"]+$loan_allocation["fees_waived"]+$loan_allocation["penalty_waived"],$decimals)); ?></th>
                                        <th><?php echo e(number_format($loan_allocation["principal_written_off"]+$loan_allocation["interest_written_off"]+$loan_allocation["fees_written_off"]+$loan_allocation["penalty_written_off"],$decimals)); ?></th>
                                        <th><?php echo e(number_format(($loan_allocation["principal"]-$loan_allocation["principal_paid"]-$loan_allocation["principal_waived"]-$loan_allocation["principal_written_off"])+($loan_allocation["interest"]-$loan_allocation["interest_paid"]-$loan_allocation["interest_waived"]-$loan_allocation["interest_written_off"])+($loan_allocation["fees"]-$loan_allocation["fees_paid"]-$loan_allocation["fees_waived"]-$loan_allocation["fees_written_off"])+($loan_allocation["penalty"]-$loan_allocation["penalty_paid"]-$loan_allocation["penalty_waived"]-$loan_allocation["penalty_written_off"]),$decimals)); ?></th>
                                        <th><?php echo e(number_format(0,$decimals)); ?></th>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                            <div class="col-sm-4 col-md-4">
                                <table class="table table-striped table-bordered">
                                    <tbody>
                                    <?php if($loan->client_type=="client"): ?>
                                        <tr>
                                            <th class="table-bold-loan"><?php echo e(trans_choice('general.client',1)); ?></th>
                                            <td>
                                        <span class="padded-td">
                                             <?php if(!empty($loan->client)): ?>
                                                <?php if($loan->client->client_type=="individual"): ?>
                                                    <a href="<?php echo e(url('client/'.$loan->client_id.'/show')); ?>"><?php echo e($loan->client->first_name); ?> <?php echo e($loan->client->middle_name); ?> <?php echo e($loan->client->last_name); ?></a>

                                                <?php else: ?>
                                                    <a href="<?php echo e(url('client/'.$loan->client_id.'/show')); ?>"><?php echo e($loan->client->full_name); ?></a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </span>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                    <?php if($loan->client_type=="group"): ?>
                                        <tr>
                                            <th class="table-bold-loan"><?php echo e(trans_choice('general.group',1)); ?></th>
                                            <td>
                                        <span class="padded-td">
                                             <?php if(!empty($loan->group)): ?>
                                                <a href="<?php echo e(url('group/'.$loan->group_id.'/show')); ?>"><?php echo e($loan->group->name); ?></a>
                                            <?php endif; ?>
                                        </span>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.currency',1)); ?></th>
                                        <td>
                                        <span class="padded-td">
                                              <?php if(!empty($loan->currency)): ?>
                                                <?php echo e($loan->currency->name); ?>

                                            <?php endif; ?>
                                        </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.officer',1)); ?></th>
                                        <td>
                                        <span class="padded-td">
                                              <?php if(!empty($loan->loan_officer)): ?>
                                                <?php echo e($loan->loan_officer->first_name); ?> <?php echo e($loan->loan_officer->last_name); ?>

                                            <?php endif; ?>
                                        </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.external_id',1)); ?> </th>
                                        <td>
                                            <span class="padded-td"><?php echo e($loan->external_id); ?></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.purpose',1)); ?></th>
                                        <td>
                                        <span class="padded-td">
                                              <?php if(!empty($loan->loan_purpose)): ?>
                                                <?php echo e($loan->loan_purpose->name); ?>

                                            <?php endif; ?>
                                        </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.proposed',1)); ?> <?php echo e(trans_choice('general.amount',1)); ?></th>
                                        <td>
                                            <span class="padded-td"><?php echo e(number_format($loan->applied_amount,$loan->loan_product->decimals)); ?></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.approved',1)); ?> <?php echo e(trans_choice('general.amount',1)); ?></th>
                                        <td>
                                            <span class="padded-td"><?php echo e(number_format($loan->approved_amount,$loan->loan_product->decimals)); ?></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-loan"> <?php echo e(trans_choice('general.disbursed',1)); ?> <?php echo e(trans_choice('general.amount',1)); ?></th>
                                        <td>
                                            <span class="padded-td"><?php echo e(number_format($loan->principal,$loan->loan_product->decimals)); ?></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th class="table-bold-loan"><?php echo e(trans_choice('general.disbursement',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></th>
                                        <td>
                                            <span class="padded-td"><?php echo e($loan->disbursement_date); ?></span>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>

                            </div>
                        </div>
                        <div class="modal fade" id="disburse_loan_modal">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title"><?php echo e(trans_choice('general.disburse',1)); ?> <?php echo e(trans_choice('general.loan',1)); ?></h4>
                                    </div>
                                    <form method="post" action="<?php echo e(url('loan/'.$loan->id.'/disburse')); ?>"
                                          class="form-horizontal "
                                          enctype="multipart/form-data" id="disburse_loan_form">
                                        <?php echo e(csrf_field()); ?>

                                        <div class="modal-body">
                                            <div class="form-group">
                                                <label for="disbursement_date"
                                                       class="control-label col-md-4"><?php echo e(trans_choice('general.disbursement',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></label>
                                                <div class="col-md-8">
                                                    <input type="text" name="disbursement_date"
                                                           class="form-control date-picker"
                                                           value="<?php echo e($loan->expected_disbursement_date); ?>"
                                                           required id="disbursement_date">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="first_repayment_date"
                                                       class="control-label col-md-4"><?php echo e(trans_choice('general.first',1)); ?> <?php echo e(trans_choice('general.repayment',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></label>
                                                <div class="col-md-8">
                                                    <input type="text" name="first_repayment_date"
                                                           class="form-control date-picker"
                                                           value="<?php echo e($loan->expected_first_repayment_date); ?>"
                                                           required id="first_repayment_date">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="payment_type_id"
                                                       class="control-label col-md-4"><?php echo e(trans_choice('general.payment',1)); ?> <?php echo e(trans_choice('general.type',1)); ?>

                                                </label>
                                                <div class="col-md-8">
                                                    <select name="payment_type_id" class="form-control select2"
                                                            id="payment_type_id" required>
                                                        <option></option>
                                                        <?php $__currentLoopData = \App\Models\PaymentType::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($key->id); ?>"><?php echo e($key->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="approved_amount"
                                                       class="control-label col-md-4"><?php echo e(trans_choice('general.show',1)); ?> <?php echo e(trans_choice('general.payment',1)); ?> <?php echo e(trans_choice('general.detail',2)); ?></label>
                                                <div class="col-md-8">
                                                    <button type="button" class="btn btn-primary" data-toggle="collapse"
                                                            data-target="#show_payment_details">
                                                        <i class="fa fa-plus"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <div id="show_payment_details" class="collapse">
                                                <div class="form-group">
                                                    <label for="account_number"
                                                           class="control-label col-md-4"><?php echo e(trans_choice('general.account',1)); ?>

                                                        #</label>
                                                    <div class="col-md-8">
                                                        <input type="text" name="account_number"
                                                               class="form-control"
                                                               value=""
                                                               id="account_number">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label for="cheque_number"
                                                           class="control-label col-md-4"><?php echo e(trans_choice('general.cheque',1)); ?>

                                                        #</label>
                                                    <div class="col-md-8">
                                                        <input type="text" name="cheque_number"
                                                               class="form-control"
                                                               value=""
                                                               id="cheque_number">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label for="routing_code"
                                                           class="control-label col-md-4"><?php echo e(trans_choice('general.routing_code',1)); ?></label>
                                                    <div class="col-md-8">
                                                        <input type="text" name="routing_code"
                                                               class="form-control"
                                                               value=""
                                                               id="routing_code">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label for="receipt_number"
                                                           class="control-label col-md-4"><?php echo e(trans_choice('general.receipt',1)); ?>

                                                        #</label>
                                                    <div class="col-md-8">
                                                        <input type="text" name="receipt_number"
                                                               class="form-control"
                                                               value=""
                                                               id="receipt_number">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label for="bank"
                                                           class="control-label col-md-4"><?php echo e(trans_choice('general.bank',1)); ?>

                                                        #</label>
                                                    <div class="col-md-8">
                                                        <input type="text" name="bank"
                                                               class="form-control"
                                                               value=""
                                                               id="bank">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="disbursed_notes"
                                                       class="control-label col-md-4"><?php echo e(trans_choice('general.note',2)); ?></label>
                                                <div class="col-md-8">
                                                     <textarea name="disbursed_notes" class="form-control"
                                                               id="disbursed_notes"
                                                               rows="3"><?php echo e(old('disbursed_notes')); ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-default pull-left"
                                                    data-dismiss="modal"><?php echo e(trans_choice('general.close',1)); ?></button>
                                            <button type="submit"
                                                    class="btn btn-primary"><?php echo e(trans_choice('general.save',1)); ?></button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                    <?php endif; ?>
                    <?php if($loan->status=="withdrawn"): ?>
                        <div class="row">
                            <div class="col-md-12">
                                <blockquote>
                                    <p><?php echo e($loan->withdrawn_notes); ?></p>
                                    <small><?php echo e($loan->withdrawn_date); ?></small>
                                </blockquote>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($loan->status=="declined"): ?>
                        <div class="row">
                            <div class="col-md-12">
                                <blockquote>
                                    <p><?php echo e($loan->declined_notes); ?></p>
                                    <small><?php echo e($loan->declined_date); ?></small>
                                </blockquote>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($loan->status=="written_off"): ?>
                        <div class="row">
                            <div class="col-md-12">
                                <blockquote>
                                    <p><?php echo e($loan->written_off_notes); ?></p>
                                    <small><?php echo e($loan->written_off_date); ?></small>
                                </blockquote>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    <?php if(Sentinel::hasAccess('loans.view')): ?>
                        <li class="active"><a href="#account_details" data-toggle="tab"
                                              aria-expanded="false"><?php echo e(trans_choice('general.account',1)); ?> <?php echo e(trans_choice('general.detail',2)); ?></a>
                        </li>
                    <?php endif; ?>
                    <?php if($loan->status=="disbursed" || $loan->status=="closed" || $loan->status=="written_off" || $loan->status=="rescheduled" ): ?>
                        <?php if(Sentinel::hasAccess('loans.view_repayment_schedule')): ?>
                            <li class=""><a href="#repayment_schedule" data-toggle="tab"
                                            aria-expanded="false"><?php echo e(trans_choice('general.repayment',1)); ?> <?php echo e(trans_choice('general.schedule',1)); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(Sentinel::hasAccess('loans.transactions.view')): ?>
                            <li class=""><a href="#transactions" data-toggle="tab"
                                            aria-expanded="false"><?php echo e(trans_choice('general.transaction',2)); ?></a>
                            </li>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if(Sentinel::hasAccess('loans.documents.view')): ?>
                        <li class=""><a href="#documents" data-toggle="tab"
                                        aria-expanded="false"><?php echo e(trans_choice('general.document',2)); ?></a>
                        </li>
                    <?php endif; ?>
                    <?php if(Sentinel::hasAccess('loans.documents.view')): ?>
                        <li class=""><a href="#collateral" data-toggle="tab"
                                        aria-expanded="false"><?php echo e(trans_choice('general.collateral',1)); ?></a>
                        </li>
                    <?php endif; ?>
                    <?php if(Sentinel::hasAccess('loans.guarantors.view')): ?>
                        <li class=""><a href="#guarantors" data-toggle="tab"
                                        aria-expanded="false"><?php echo e(trans_choice('general.guarantor',2)); ?></a>
                        </li>
                    <?php endif; ?>
                    <?php if(Sentinel::hasAccess('loans.notes.view')): ?>
                        <li class=""><a href="#notes" data-toggle="tab"
                                        aria-expanded="false"><?php echo e(trans_choice('general.note',2)); ?></a>
                        </li>
                    <?php endif; ?>
                    <?php if($loan->client_type=="group"): ?>
                        <li class=""><a href="#group_allocation" data-toggle="tab"
                                        aria-expanded="false"><?php echo e(trans_choice('general.group',1)); ?> <?php echo e(trans_choice('general.allocation',1)); ?></a>
                        </li>
                    <?php endif; ?>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="account_details">
                        <table class="table table-striped table-hover">
                            <tr>
                                <td><?php echo e(trans_choice('general.repayment',1)); ?> <?php echo e(trans_choice('general.strategy',1)); ?></td>
                                <td>
                                    <?php if($loan->loan_product->loan_transaction_strategy=="penalty_fees_interest_principal"): ?>
                                        <?php echo e(trans_choice('general.penalty_fees_interest_principal',1)); ?>

                                    <?php endif; ?>
                                    <?php if($loan->loan_product->loan_transaction_strategy=="principal_interest_penalty_fees"): ?>
                                        <?php echo e(trans_choice('general.principal_interest_penalty_fees',1)); ?>

                                    <?php endif; ?>
                                    <?php if($loan->loan_product->loan_transaction_strategy=="interest_principal_penalty_fees"): ?>
                                        <?php echo e(trans_choice('general.interest_principal_penalty_fees',1)); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.term',1)); ?></td>
                                <td>
                                    <?php echo e($loan->loan_term); ?>

                                    <?php if($loan->loan_term_type=="days"): ?>
                                        <?php echo e(trans_choice('general.day',2)); ?>

                                    <?php endif; ?>
                                    <?php if($loan->loan_term_type=="weeks"): ?>
                                        <?php echo e(trans_choice('general.week',2)); ?>

                                    <?php endif; ?>
                                    <?php if($loan->loan_term_type=="months"): ?>
                                        <?php echo e(trans_choice('general.month',2)); ?>

                                    <?php endif; ?>
                                    <?php if($loan->loan_term_type=="years"): ?>
                                        <?php echo e(trans_choice('general.year',2)); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('general.repayment',2)); ?></td>
                                <td>
                                    <?php echo e(trans_choice('general.every',1)); ?> <?php echo e($loan->repayment_frequency); ?>

                                    <?php if($loan->repayment_frequency_type=="days"): ?>
                                        <?php echo e(trans_choice('general.day',2)); ?>

                                    <?php endif; ?>
                                    <?php if($loan->repayment_frequency_type=="weeks"): ?>
                                        <?php echo e(trans_choice('general.week',2)); ?>

                                    <?php endif; ?>
                                    <?php if($loan->repayment_frequency_type=="months"): ?>
                                        <?php echo e(trans_choice('general.month',2)); ?>

                                    <?php endif; ?>
                                    <?php if($loan->repayment_frequency_type=="years"): ?>
                                        <?php echo e(trans_choice('general.year',2)); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('general.interest',1)); ?> <?php echo e(trans_choice('general.method',1)); ?></td>
                                <td>
                                    <?php if($loan->interest_method=="flat"): ?>
                                        <?php echo e(trans_choice('general.flat',1)); ?>

                                    <?php endif; ?>
                                    <?php if($loan->interest_method=="declining_balance"): ?>
                                        <?php echo e(trans_choice('general.declining_balance',1)); ?>

                                        <?php if($loan->armotization_method=="equal_installment"): ?>
                                            -<?php echo e(trans_choice('general.equal_installment',1)); ?>

                                        <?php endif; ?>
                                        <?php if($loan->armotization_method=="equal_principal"): ?>
                                            -<?php echo e(trans_choice('general.equal_principal',1)); ?>

                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('general.interest',1)); ?></td>
                                <td>
                                    <?php echo e($loan->interest_rate); ?> %
                                    <?php if($loan->override_interest==0): ?>
                                        <?php echo e(trans_choice('general.per',1)); ?>

                                        <?php if($loan->interest_rate_type=="day"): ?>
                                            <?php echo e(trans_choice('general.day',1)); ?>

                                        <?php endif; ?>
                                        <?php if($loan->interest_rate_type=="week"): ?>
                                            <?php echo e(trans_choice('general.week',1)); ?>

                                        <?php endif; ?>
                                        <?php if($loan->interest_rate_type=="month"): ?>
                                            <?php echo e(trans_choice('general.month',1)); ?>

                                        <?php endif; ?>
                                        <?php if($loan->interest_rate_type=="year"): ?>
                                            <?php echo e(trans_choice('general.year',1)); ?>

                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('general.grace_on_principal',1)); ?></td>
                                <td>
                                    <?php echo e($loan->grace_on_principal); ?>

                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('general.grace_on_interest_payment',1)); ?></td>
                                <td>
                                    <?php echo e($loan->grace_on_interest_payment); ?>

                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('general.grace_on_interest_charged',1)); ?></td>
                                <td>
                                    <?php echo e($loan->grace_on_interest_charged); ?>

                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('general.fund',1)); ?></td>
                                <td>
                                    <?php if(!empty($loan->fund)): ?>
                                        <?php echo e($loan->fund->name); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php $__currentLoopData = \App\Models\CustomFieldMeta::where('category', 'loans')->where('parent_id', $loan->id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <?php if(!empty($key->custom_field)): ?>
                                            <?php echo e($key->custom_field->name); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($key->custom_field->field_type=="checkbox"): ?>
                                            <?php $__currentLoopData = unserialize($key->name); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v=>$k): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo e($k); ?><br>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <?php echo e($key->name); ?>

                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(trans_choice('general.submitted',1)); ?> <?php echo e(trans_choice('general.on',1)); ?></td>
                                <td>
                                    <?php echo e($loan->created_date); ?>

                                    <?php if(!empty($loan->created_by)): ?>
                                        by <?php echo e($loan->created_by->first_name); ?> <?php echo e($loan->created_by->last_name); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('general.approved',1)); ?> <?php echo e(trans_choice('general.on',1)); ?></td>
                                <td>
                                    <?php echo e($loan->approved_date); ?>

                                    <?php if(!empty($loan->approved_by)): ?>
                                        by <?php echo e($loan->approved_by->first_name); ?> <?php echo e($loan->approved_by->last_name); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(trans_choice('general.disbursed',1)); ?> <?php echo e(trans_choice('general.on',1)); ?></td>
                                <td>
                                    <?php echo e($loan->disbursed_date); ?>

                                    <?php if(!empty($loan->disbursed_by)): ?>
                                        by <?php echo e($loan->disbursed_by->first_name); ?> <?php echo e($loan->disbursed_by->last_name); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <?php if(Sentinel::hasAccess('loans.documents.view')): ?>
                        <div class="tab-pane" id="documents">
                            <div class="row">
                                <div class="col-md-12">
                                    <?php if(Sentinel::hasAccess('loans.documents.create')): ?>
                                        <a href="#add_document_modal"
                                           data-toggle="modal" class="btn btn-info pull-right"><i
                                                    class="fa fa-plus"></i> <?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.document',1)); ?>

                                        </a>
                                    <?php endif; ?>
                                </div>
                                <div class="col-md-12 table-responsive">
                                    <table class="table table-hover table-striped" id="">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(trans_choice('general.name',1)); ?></th>
                                            <th><?php echo e(trans('general.description')); ?></th>
                                            <th><?php echo e(trans_choice('general.action',1)); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = \App\Models\Document::where('record_id',$loan->id)->where('type','loan')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($key->name); ?></td>
                                                <td><?php echo $key->notes; ?></td>
                                                <td>
                                                    <a class="" href="<?php echo e(asset('uploads/'.$key->location)); ?>"
                                                       target="_blank"><i class="fa fa-download"></i> </a>
                                                    <?php if(Sentinel::hasAccess('loans.documents.delete')): ?>
                                                        <a class="confirm"
                                                           href="<?php echo e(url('loan/document/'.$key->id.'/delete')); ?>"><i
                                                                    class="fa fa-trash"></i> </a>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(Sentinel::hasAccess('loans.collateral.view')): ?>
                        <div class="tab-pane" id="collateral">
                            <div class="row">
                                <div class="col-md-12">
                                    <?php if(Sentinel::hasAccess('loans.collateral.create')): ?>
                                        <a href="#add_collateral_modal"
                                           data-toggle="modal" class="btn btn-info pull-right"><i
                                                    class="fa fa-plus"></i> <?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.collateral',1)); ?>

                                        </a>
                                    <?php endif; ?>
                                </div>
                                <div class="col-md-12 table-responsive">
                                    <table class="table table-hover table-striped" id="">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(trans_choice('general.type',1)); ?></th>
                                            <th><?php echo e(trans('general.value')); ?></th>
                                            <th><?php echo e(trans('general.description')); ?></th>
                                            <th><?php echo e(trans('general.serial')); ?></th>
                                            <th><?php echo e(trans_choice('general.action',1)); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $loan->collateral; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td>
                                                    <?php if(!empty($key->type)): ?>
                                                        <?php echo e($key->type->name); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($key->value); ?></td>
                                                <td><?php echo $key->description; ?></td>
                                                <td><?php echo e($key->serial); ?></td>
                                                <td>
                                                    <a data-id="<?php echo e($key->id); ?>" href="#" data-toggle="modal"
                                                       data-target="#view_collateral"><i class="fa fa-eye"></i> </a>
                                                    <?php if(Sentinel::hasAccess('loans.collateral.update')): ?>
                                                        <a data-id="<?php echo e($key->id); ?>" href="#" data-toggle="modal"
                                                           data-target="#edit_collateral"><i class="fa fa-edit"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                    <?php if(Sentinel::hasAccess('loans.collateral.delete')): ?>
                                                        <a class="confirm"
                                                           href="<?php echo e(url('loan/collateral/'.$key->id.'/delete')); ?>"><i
                                                                    class="fa fa-trash"></i> </a>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(Sentinel::hasAccess('loans.guarantors.view')): ?>
                        <div class="tab-pane" id="guarantors">
                            <div class="row">
                                <div class="col-md-12">
                                    <?php if(Sentinel::hasAccess('loans.guarantors.create')): ?>
                                        <a href="#add_guarantor_modal"
                                           data-toggle="modal" class="btn btn-info pull-right"><i
                                                    class="fa fa-plus"></i> <?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.guarantor',1)); ?>

                                        </a>
                                    <?php endif; ?>
                                </div>
                                <div class="col-md-12 table-responsive">
                                    <table id="" class="table table-striped table-condensed table-hover">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(trans_choice('general.name',1)); ?></th>
                                            <th><?php echo e(trans_choice('general.relationship',1)); ?></th>
                                            <th><?php echo e(trans_choice('general.type',1)); ?></th>
                                            <th><?php echo e(trans_choice('general.amount',1)); ?></th>
                                            <th><?php echo e(trans_choice('general.mobile',1)); ?></th>
                                            <th><?php echo e(trans_choice('general.action',1)); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $loan->guarantors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td>
                                                    <?php if($key->is_client==1): ?>
                                                        <?php if(!empty($key->client)): ?>
                                                            <a href="<?php echo e(url('client/'.$key->client_id.'/show')); ?>"><?php echo e($key->client->first_name); ?> <?php echo e($key->client->midddle_name); ?> <?php echo e($key->client->last_name); ?></a>
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        <?php echo e($key->first_name); ?> <?php echo e($key->midddle_name); ?> <?php echo e($key->last_name); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if(!empty($key->relationship)): ?>
                                                        <?php echo e($key->relationship->name); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if($key->is_client==1): ?>
                                                        <?php echo e(trans_choice('general.client',1)); ?>

                                                    <?php else: ?>
                                                        <?php echo e(trans_choice('general.external',1)); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($key->amount); ?></td>
                                                <td>
                                                    <?php if($key->is_client==1): ?>
                                                        <?php if(!empty($key->client)): ?>
                                                            <?php echo e($key->client->mobile); ?>

                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        <?php echo e($key->mobile); ?>

                                                    <?php endif; ?>


                                                </td>
                                                <td>
                                                    <?php if($key->is_client==1): ?>
                                                        <a href="<?php echo e(url('client/'.$key->client_id.'/show')); ?>"><i
                                                                    class="fa fa-eye"></i> </a>
                                                    <?php else: ?>
                                                        <a data-id="<?php echo e($key->id); ?>" href="#" data-toggle="modal"
                                                           data-target="#view_guarantor"><i class="fa fa-eye"></i> </a>
                                                    <?php endif; ?>
                                                    <?php if(Sentinel::hasAccess('loans.guarantors.update')): ?>
                                                        <a data-id="<?php echo e($key->id); ?>" href="#" data-toggle="modal"
                                                           data-target="#edit_guarantor"><i class="fa fa-edit"></i> </a>
                                                    <?php endif; ?>
                                                    <?php if(Sentinel::hasAccess('loans.guarantors.delete')): ?>
                                                        <a class="confirm"
                                                           href="<?php echo e(url('loan/guarantor/'.$key->id.'/delete')); ?>"><i
                                                                    class="fa fa-trash"></i> </a>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(Sentinel::hasAccess('loans.notes.view')): ?>
                        <div class="tab-pane" id="notes">
                            <div class="row">
                                <div class="col-md-12">
                                    <?php if(Sentinel::hasAccess('loans.notes.create')): ?>
                                        <a href="#add_note_modal"
                                           data-toggle="modal" class="btn btn-info pull-right"><i
                                                    class="fa fa-plus"></i> <?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.note',1)); ?>

                                        </a>
                                    <?php endif; ?>
                                </div>
                                <div class="col-md-12 table-responsive">
                                    <table class="table table-hover table-striped" id="">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(trans_choice('general.note',1)); ?></th>
                                            <th><?php echo e(trans('general.date')); ?></th>
                                            <th><?php echo e(trans('general.created_by')); ?></th>
                                            <th><?php echo e(trans_choice('general.action',1)); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = \App\Models\Note::where('reference_id',$loan->id)->where('type','loan')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo $key->notes; ?></td>
                                                <td><?php echo $key->created_at; ?></td>
                                                <td>
                                                    <?php if(!empty($key->created_by)): ?>
                                                        <?php echo e($key->created_by->first_name); ?> <?php echo e($key->created_by->last_name); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <a data-id="<?php echo e($key->id); ?>" href="#" data-toggle="modal"
                                                       data-target="#view_note"><i class="fa fa-eye"></i> </a>
                                                    <?php if(Sentinel::hasAccess('loans.notes.update')): ?>
                                                        <a data-id="<?php echo e($key->id); ?>" href="#" data-toggle="modal"
                                                           data-target="#edit_note"><i class="fa fa-edit"></i> </a>
                                                    <?php endif; ?>
                                                    <?php if(Sentinel::hasAccess('loans.notes.delete')): ?>
                                                        <a class="confirm"
                                                           href="<?php echo e(url('loan/note/'.$key->id.'/delete')); ?>"><i
                                                                    class="fa fa-trash"></i> </a>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($loan->status=="disbursed" || $loan->status=="closed" || $loan->status=="written_off" || $loan->status=="rescheduled" ): ?>
                        <?php if(Sentinel::hasAccess('loans.view_repayment_schedule')): ?>
                            <div class="tab-pane" id="repayment_schedule">
                                <div class="row">
                                    <div class="col-md-12">

                                    </div>
                                    <div class="col-md-12 table-responsive">
                                        <table class="pretty displayschedule" id="repaymentschedule"
                                               style="margin-top: 20px;">
                                            <colgroup span="3"></colgroup>
                                            <colgroup span="3">
                                                <col class="lefthighlightcol">
                                                <col>
                                                <col class="righthighlightcol">
                                            </colgroup>
                                            <colgroup span="3">
                                                <col class="lefthighlightcol">
                                                <col>
                                                <col class="righthighlightcol">
                                            </colgroup>
                                            <colgroup span="3"></colgroup>

                                            <thead>
                                            <tr>
                                                <th class="empty" scope="colgroup" colspan="4">&nbsp;</th>
                                                <th class="highlightcol" scope="colgroup"
                                                    colspan="3"><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.amount',1)); ?> <?php echo e(trans_choice('general.and',1)); ?>

                                                    <?php echo e(trans_choice('general.balance',1)); ?>

                                                </th>
                                                <th class="highlightcol" scope="colgroup"
                                                    colspan="3"><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.cost',1)); ?> <?php echo e(trans_choice('general.of',1)); ?> <?php echo e(trans_choice('general.loan',1)); ?>

                                                </th>
                                                <th class="empty" scope="colgroup" colspan="1">&nbsp;</th>
                                            </tr>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th scope="col"><?php echo e(trans_choice('general.date',1)); ?></th>
                                                <th scope="col"><?php echo e(trans_choice('general.paid',1)); ?> <?php echo e(trans_choice('general.by',1)); ?></th>
                                                <th scope="col"></th>
                                                <th class="lefthighlightcolheader"
                                                    scope="col"><?php echo e(trans_choice('general.disbursement',1)); ?></th>
                                                <th scope="col"><?php echo e(trans_choice('general.principal',1)); ?> <?php echo e(trans_choice('general.due',1)); ?></th>
                                                <th class="righthighlightcolheader"
                                                    scope="col"><?php echo e(trans_choice('general.principal',1)); ?> <?php echo e(trans_choice('general.balance',1)); ?></th>

                                                <th class="lefthighlightcolheader"
                                                    scope="col"><?php echo e(trans_choice('general.interest',1)); ?> <?php echo e(trans_choice('general.due',1)); ?></th>
                                                <th scope="col"><?php echo e(trans_choice('general.fee',2)); ?></th>
                                                <th class="righthighlightcolheader"
                                                    scope="col"><?php echo e(trans_choice('general.penalty',2)); ?></th>

                                                <th scope="col"><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.due',1)); ?></th>
                                                <th scope="col"><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.paid',1)); ?></th>
                                                <th scope="col"><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.outstanding',1)); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                            $count = 1;
                                            $principal_balance = $loan->principal;
                                            $total_principal = 0;
                                            $total_interest = 0;
                                            $total_penalties = 0;
                                            $total_fees = 0;
                                            $total_due = 0;
                                            $total_paid = 0;
                                            $total_outstanding = 0;
                                            $disbursement_charges = \App\Models\LoanTransaction::where('loan_id', $loan->id)->where('transaction_type', 'disbursement_fee')->where('reversed', 0)->sum('debit');
                                            ?>
                                            <tr>
                                                <td scope="row"></td>
                                                <td><?php echo e($loan->disbursement_date); ?></td>

                                                <td><span style="color: #eb2442;"></span></td>
                                                <td>&nbsp;</td>
                                                <td class="lefthighlightcolheader"><?php echo e(number_format($loan->principal,$loan->loan_product->decimals)); ?></td>
                                                <td></td>
                                                <td class="righthighlightcolheader"><?php echo e(number_format($loan->principal,$loan->loan_product->decimals)); ?></td>

                                                <td class="lefthighlightcolheader">


                                                </td>
                                                <td><?php echo e(number_format($disbursement_charges,$loan->loan_product->decimals)); ?></td>
                                                <td class="righthighlightcolheader"></td>

                                                <td></td>
                                                <td><?php echo e(number_format($disbursement_charges,$loan->loan_product->decimals)); ?></td>
                                                <td></td>
                                            </tr>
                                            <?php $__currentLoopData = $loan->repayment_schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                $principal_balance = $principal_balance - $key->principal - $key->principal_waived - $key->principal_written_off;
                                                $total_principal = $total_principal + $key->principal - $key->principal_waived - $key->principal_written_off;
                                                $total_interest = $total_interest + $key->interest - $key->interest_waived - $key->interest_written_off;
                                                $total_penalties = $total_penalties + $key->penalty - $key->penalty_waived - $key->penalty_written_off;
                                                $total_fees = $total_fees + $key->fees - $key->fees_waived - $key->fees_written_off;
                                                $total_due = $total_due + $key->principal - $key->principal_waived - $key->principal_written_off + $key->interest - $key->interest_waived - $key->interest_written_off + $key->penalties - $key->penalty_waived - $key->penalty_written_off + $key->fees - $key->fees_waived - $key->fees_written_off;
                                                $total_paid = $total_paid + $key->principal_paid + $key->interest_paid + $key->penalty_paid + $key->fees_paid;
                                                $total_outstanding = $total_outstanding + $key->principal - $key->principal_waived - $key->principal_written_off + $key->interest - $key->interest_waived - $key->interest_written_off + $key->penalty - $key->penalty_waived - $key->penalty_written_off + $key->fees - $key->fees_waived - $key->fees_written_off;
                                                ?>
                                                <tr>
                                                    <td scope="row"><?php echo e($count); ?></td>
                                                    <td><?php echo e($key->due_date); ?></td>
                                                    <td>
                                                        <?php if(!empty($key->from_date)): ?>
                                                            <?php if(strtotime($key->due_date) >strtotime($key->from_date)): ?>
                                                                <span style=""><?php echo e($key->from_date); ?></span>
                                                            <?php else: ?>
                                                                <span style="color: #eb2442;"><?php echo e($key->from_date); ?></span>
                                                            <?php endif; ?>
                                                        <?php else: ?>

                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if(!empty($key->from_date)): ?>
                                                            <?php if(strtotime($key->due_date) >strtotime($key->from_date)): ?>
                                                                <i class="fa fa-check" data-toggle="tooltip"
                                                                   title="<?php echo e(trans_choice('general.timely',1)); ?>"></i>
                                                            <?php else: ?>
                                                                <i class="fa fa-question" data-toggle="tooltip"
                                                                   title="<?php echo e(trans_choice('general.late',1)); ?>"></i>
                                                            <?php endif; ?>
                                                        <?php else: ?>
                                                            <?php if(strtotime(date("Y-m-d")) <strtotime($key->due_date)): ?>
                                                                &nbsp;
                                                            <?php else: ?>
                                                                <i class="fa fa-question" data-toggle="tooltip"
                                                                   title="<?php echo e(trans_choice('general.late',1)); ?>"></i>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td class="lefthighlightcolheader"></td>
                                                    <td>
                                                        <?php if( ($key->principal_waived +$key->principal_written_off)>0): ?>
                                                            <span style="color: #eb2442;"><s><?php echo e(number_format($key->principal_waived +$key->principal_written_off,$loan->loan_product->decimals)); ?></s></span>
                                                        <?php endif; ?>
                                                        <?php echo e(number_format($key->principal- $key->principal_waived - $key->principal_written_off,$loan->loan_product->decimals)); ?>

                                                    </td>
                                                    <td class="righthighlightcolheader"><?php echo e(number_format($principal_balance,$loan->loan_product->decimals)); ?></td>

                                                    <td class="lefthighlightcolheader">
                                                        <?php if( ($key->interest_waived +$key->interest_written_off)>0): ?>
                                                            <span style="color: #eb2442;"><s><?php echo e(number_format($key->interest_waived +$key->interest_written_off,$loan->loan_product->decimals)); ?></s></span>
                                                        <?php endif; ?>
                                                        <?php echo e(number_format($key->interest- $key->interest_waived - $key->interest_written_off,$loan->loan_product->decimals)); ?>

                                                    </td>
                                                    <td>
                                                        <?php if( ($key->fees_waived +$key->fees_written_off)>0): ?>
                                                            <span style="color: #eb2442;"><s><?php echo e(number_format($key->fees_waived +$key->fees_written_off,$loan->loan_product->decimals)); ?></s></span>
                                                        <?php endif; ?>
                                                        <?php echo e(number_format($key->fees- $key->fees_waived - $key->fees_written_off,$loan->loan_product->decimals)); ?>

                                                    </td>
                                                    <td class="righthighlightcolheader">
                                                        <?php if( ($key->penalty_waived +$key->penalty_written_off)>0): ?>
                                                            <span style="color: #eb2442;"><s><?php echo e(number_format($key->penalty_waived +$key->penalty_written_off,$loan->loan_product->decimals)); ?></s></span>
                                                        <?php endif; ?>
                                                        <?php echo e(number_format($key->penalty- $key->penalty_waived - $key->penalty_written_off,$loan->loan_product->decimals)); ?>

                                                    </td>

                                                    <td><?php echo e(number_format($key->principal- $key->principal_waived - $key->principal_written_off + $key->interest- $key->interest_waived - $key->interest_written_off + $key->penalty- $key->penalty_waived - $key->penalty_written_off + $key->fees- $key->fees_waived - $key->fees_written_off,$loan->loan_product->decimals)); ?></td>
                                                    <td><?php echo e(number_format($key->principal_paid + $key->interest_paid + $key->penalty_paid + $key->fees_paid,$loan->loan_product->decimals)); ?></td>
                                                    <td><?php echo e(number_format($key->principal- $key->principal_waived - $key->principal_written_off + $key->interest- $key->interest_waived - $key->interest_written_off + $key->penalty- $key->penalty_waived - $key->penalty_written_off + $key->fees- $key->fees_waived - $key->fees_written_off-($key->principal_paid + $key->interest_paid + $key->penalty_paid + $key->fees_paid),$loan->loan_product->decimals)); ?></td>
                                                </tr>
                                                <?php
                                                $count++;
                                                ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                            <tfoot class="ui-widget-header">
                                            <tr>
                                                <th colspan="2"><?php echo e(trans_choice('general.total',1)); ?></th>
                                                <th></th>
                                                <th></th>

                                                <th class="lefthighlightcolheader"> <?php echo e(number_format($loan->principal,$loan->loan_product->decimals)); ?></th>
                                                <th> <?php echo e(number_format($total_principal,$loan->loan_product->decimals)); ?></th>
                                                <th class="righthighlightcolheader">&nbsp;</th>

                                                <th class="lefthighlightcolheader"><?php echo e(number_format($total_interest,$loan->loan_product->decimals)); ?></th>
                                                <th><?php echo e(number_format($total_fees,$loan->loan_product->decimals)); ?></th>
                                                <th class="righthighlightcolheader"><?php echo e(number_format($total_penalties,$loan->loan_product->decimals)); ?></th>

                                                <th><?php echo e(number_format($total_due,$loan->loan_product->decimals)); ?></th>
                                                <th><?php echo e(number_format($total_paid,$loan->loan_product->decimals)); ?></th>
                                                <th><?php echo e(number_format($total_outstanding-$total_paid,$loan->loan_product->decimals)); ?></th>
                                            </tr>
                                            </tfoot>
                                        </table>

                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if(Sentinel::hasAccess('loans.transactions.view')): ?>
                            <div class="tab-pane" id="transactions">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="table-responsive">
                                            <table id="repayments-data-table"
                                                   class="table  table-condensed table-hover">
                                                <thead>
                                                <tr>
                                                    <th>
                                                        <?php echo e(trans_choice('general.id',1)); ?> 
                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('general.date',1)); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('general.submitted',1)); ?> <?php echo e(trans_choice('general.on',1)); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('general.type',1)); ?>

                                                    </th>

                                                    <th>
                                                        <?php echo e(trans_choice('general.debit',1)); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('general.credit',1)); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('general.balance',1)); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('general.detail',2)); ?>

                                                    </th>
                                                    <th class="text-center">
                                                        <?php echo e(trans_choice('general.action',1)); ?>

                                                    </th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php
                                                $balance = 0;
                                                ?>
                                                <?php $__currentLoopData = \App\Models\LoanTransaction::where('loan_id',$loan->id)->whereIn('reversal_type',['user','none'])->orderBy('date','asc')->orderBy('id','asc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php
                                                    $balance = $balance + ($key->debit - $key->credit);
                                                    ?>
                                                    <tr>
                                                        <td><?php echo e($key->id); ?></td>
                                                        <td><?php echo e($key->date); ?></td>
                                                        <td><?php echo e($key->created_at); ?></td>
                                                        <td>
                                                            <?php if($key->transaction_type=='disbursement'): ?>
                                                                <?php echo e(trans_choice('general.disbursement',1)); ?>

                                                            <?php endif; ?>
                                                            <?php if($key->transaction_type=='specified_due_date_fee'): ?>
                                                                <?php echo e(trans_choice('general.specified_due_date',2)); ?>   <?php echo e(trans_choice('general.fee',1)); ?>

                                                            <?php endif; ?>
                                                            <?php if($key->transaction_type=='installment_fee'): ?>
                                                                <?php echo e(trans_choice('general.installment_fee',2)); ?>

                                                            <?php endif; ?>
                                                            <?php if($key->transaction_type=='overdue_installment_fee'): ?>
                                                                <?php echo e(trans_choice('general.overdue_installment_fee',2)); ?>

                                                            <?php endif; ?>
                                                            <?php if($key->transaction_type=='loan_rescheduling_fee'): ?>
                                                                <?php echo e(trans_choice('general.loan_rescheduling_fee',2)); ?>

                                                            <?php endif; ?>
                                                            <?php if($key->transaction_type=='overdue_maturity'): ?>
                                                                <?php echo e(trans_choice('general.overdue_maturity',2)); ?>

                                                            <?php endif; ?>
                                                            <?php if($key->transaction_type=='disbursement_fee'): ?>
                                                                <?php echo e(trans_choice('general.disbursement',1)); ?> <?php echo e(trans_choice('general.charge',2)); ?>

                                                            <?php endif; ?>
                                                            <?php if($key->transaction_type=='interest'): ?>
                                                                <?php echo e(trans_choice('general.interest',1)); ?> <?php echo e(trans_choice('general.applied',2)); ?>

                                                            <?php endif; ?>
                                                            <?php if($key->transaction_type=='repayment'): ?>
                                                                <?php echo e(trans_choice('general.repayment',1)); ?>

                                                            <?php endif; ?>
                                                            <?php if($key->transaction_type=='penalty'): ?>
                                                                <?php echo e(trans_choice('general.penalty',1)); ?>

                                                            <?php endif; ?>
                                                            <?php if($key->transaction_type=='interest_waiver'): ?>
                                                                <?php echo e(trans_choice('general.interest',1)); ?> <?php echo e(trans_choice('general.waiver',2)); ?>

                                                            <?php endif; ?>
                                                            <?php if($key->transaction_type=='waiver'): ?>
                                                                <?php echo e(trans_choice('general.waiver',2)); ?>

                                                            <?php endif; ?>
                                                            <?php if($key->transaction_type=='charge_waiver'): ?>
                                                                <?php echo e(trans_choice('general.charge',1)); ?>  <?php echo e(trans_choice('general.waiver',2)); ?>

                                                            <?php endif; ?>
                                                            <?php if($key->transaction_type=='write_off'): ?>
                                                                <?php echo e(trans_choice('general.write_off',1)); ?>

                                                            <?php endif; ?>
                                                            <?php if($key->transaction_type=='repayment_disbursement'): ?>
                                                                <?php echo e(trans_choice('general.repayment',1)); ?> <?php echo e(trans_choice('general.disbursement',1)); ?>

                                                            <?php endif; ?>
                                                            <?php if($key->transaction_type=='write_off_recovery'): ?>
                                                                <?php echo e(trans_choice('general.recovery',1)); ?> <?php echo e(trans_choice('general.repayment',1)); ?>

                                                            <?php endif; ?>
                                                            <?php if($key->reversed==1): ?>
                                                                <?php if($key->reversal_type=="user"): ?>
                                                                    <span class="text-danger"><b>(<?php echo e(trans_choice('general.user',1)); ?> <?php echo e(trans_choice('general.reversed',1)); ?>

                                                                            )</b></span>
                                                                <?php endif; ?>
                                                                <?php if($key->reversal_type=="system"): ?>
                                                                    <span class="text-danger"><b>(<?php echo e(trans_choice('general.system',1)); ?> <?php echo e(trans_choice('general.reversed',1)); ?>

                                                                            )</b></span>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td><?php echo e(number_format($key->debit,2)); ?></td>
                                                        <td><?php echo e(number_format($key->credit,2)); ?></td>
                                                        <td><?php echo e(number_format($balance,2)); ?></td>
                                                        <td> <span class="padded-td">
                                                            <?php if(!empty($loan->client)): ?>
                                                               <?php if($loan->client->client_type=="individual"): ?>
                                                                   <a href="<?php echo e(url('client/'.$loan->client_id.'/show')); ?>"><?php echo e($loan->client->first_name); ?> <?php echo e($loan->client->middle_name); ?> <?php echo e($loan->client->last_name); ?></a>
                                                                   (<?php echo e(trans_choice('general.individual',1)); ?>)
                                                               <?php else: ?>
                                                                   <a href="<?php echo e(url('client/'.$loan->client_id.'/show')); ?>"><?php echo e($loan->client->full_name); ?></a>
                                                                   (<?php echo e(trans_choice('general.business',1)); ?>)
                                                               <?php endif; ?>
                                                           <?php endif; ?>
                                                       </span></td>
                                                        <td class="">
                                                            <div class="btn-group">
                                                                <button class="btn btn-info btn-sm dropdown-toggle"
                                                                        type="button" data-toggle="dropdown"
                                                                        aria-expanded="false"><i
                                                                            class="fa fa-navicon"></i></button>
                                                                <ul class="dropdown-menu dropdown-menu-right"
                                                                    role="menu">
                                                                    <?php if(Sentinel::hasAccess('loans.transactions.view')): ?>
                                                                        <li>
                                                                            <a href="<?php echo e(url('loan/transaction/'.$key->id.'/show')); ?>"><i
                                                                                        class="fa fa-search"></i> <?php echo e(trans_choice('general.view',1)); ?>

                                                                            </a></li>
                                                                        <li>
                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='repayment' && $key->reversible==1): ?>
                                                                        <li>
                                                                            <a href="<?php echo e(url('loan/transaction/'.$key->id.'/print')); ?>"
                                                                               target="_blank"><i
                                                                                        class="fa fa-print"></i> <?php echo e(trans_choice('general.print',1)); ?> <?php echo e(trans_choice('general.receipt',1)); ?>

                                                                            </a></li>
                                                                        <li>
                                                                            <a href="<?php echo e(url('loan/transaction/'.$key->id.'/pdf')); ?>"
                                                                               target="_blank"><i
                                                                                        class="fa fa-file-pdf-o"></i> <?php echo e(trans_choice('general.pdf',1)); ?> <?php echo e(trans_choice('general.receipt',1)); ?>

                                                                            </a></li>
                                                                        <?php if(Sentinel::hasAccess('loans.transactions.update')): ?>
                                                                            <li>
                                                                                <a href="<?php echo e(url('loan/repayment/'.$key->id.'/edit')); ?>"><i
                                                                                            class="fa fa-edit"></i> <?php echo e(trans('general.edit')); ?>

                                                                                </a></li>

                                                                            <li>
                                                                                <a href="<?php echo e(url('loan/repayment/'.$key->id.'/reverse')); ?>"
                                                                                   class="delete"><i
                                                                                            class="fa fa-minus-circle"></i> <?php echo e(trans('general.reverse')); ?>

                                                                                </a></li>
                                                                        <?php endif; ?>
                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='penalty' && $key->reversible==1): ?>
                                                                        <?php if(Sentinel::hasAccess('loans.charges.waive')): ?>
                                                                            <li>
                                                                                <a href="<?php echo e(url('loan/transaction/'.$key->id.'/waive')); ?>"
                                                                                   class="delete"><i
                                                                                            class="fa fa-minus-circle"></i> <?php echo e(trans('general.waive')); ?>

                                                                                </a></li>
                                                                        <?php endif; ?>
                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='installment_fee' && $key->reversible==1): ?>
                                                                        <?php if(Sentinel::hasAccess('loans.charges.waive')): ?>
                                                                            <li>
                                                                                <a href="<?php echo e(url('loan/transaction/'.$key->id.'/waive')); ?>"
                                                                                   class="delete"><i
                                                                                            class="fa fa-minus-circle"></i> <?php echo e(trans('general.waive')); ?>

                                                                                </a></li>
                                                                        <?php endif; ?>
                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='specified_due_date_fee' && $key->reversible==1): ?>
                                                                        <?php if(Sentinel::hasAccess('loans.charges.waive')): ?>
                                                                            <li>
                                                                                <a href="<?php echo e(url('loan/transaction/'.$key->id.'/waive')); ?>"
                                                                                   class="delete"><i
                                                                                            class="fa fa-minus-circle"></i> <?php echo e(trans('general.waive')); ?>

                                                                                </a></li>
                                                                        <?php endif; ?>
                                                                    <?php endif; ?>
                                                                </ul>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="modal fade" id="waive_interest_modal">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title"><?php echo e(trans_choice('general.waive',1)); ?> <?php echo e(trans_choice('general.interest',1)); ?></h4>
                                    </div>
                                    <form method="post" action="<?php echo e(url('loan/'.$loan->id.'/interest/waive')); ?>"
                                          class="form-horizontal "
                                          enctype="multipart/form-data" id="waive_interest_form">
                                        <?php echo e(csrf_field()); ?>

                                        <div class="modal-body">
                                            <div class="form-group">
                                                <label for="waived_date"
                                                       class="control-label col-md-3"> <?php echo e(trans_choice('general.date',1)); ?></label>
                                                <div class="col-md-9">
                                                    <input type="text" name="date"
                                                           class="form-control date-picker"
                                                           value="<?php echo e(date("Y-m-d")); ?>"
                                                           required id="waived_date">
                                                </div>
                                            </div>
                                            <?php
                                            $waive_amount = DB::table('loan_repayment_schedules')->select(DB::raw('(COALESCE(interest,0)-COALESCE(interest_waived,0)-COALESCE(interest_written_off,0)-COALESCE(interest_paid,0)) as interest_due'))->where('loan_id', $loan->id)->orderBy('due_date', 'asc')->havingRaw("interest_due>0")->first();
                                            if (empty($waive_amount)) {
                                                $waive_amount = 0;
                                            } else {
                                                $waive_amount = $waive_amount->interest_due;
                                            }
                                            ?>
                                            <div class="form-group">
                                                <label for="waived_amount"
                                                       class="control-label col-md-3"><?php echo e(trans_choice('general.amount',1)); ?></label>
                                                <div class="col-md-9">
                                                    <input type="number" name="amount" class="form-control"
                                                           value="<?php echo e($waive_amount); ?>"
                                                           required id="waived_amount">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="waived_notes"
                                                       class="control-label col-md-3"><?php echo e(trans_choice('general.note',2)); ?></label>
                                                <div class="col-md-9">
                                                     <textarea name="notes" class="form-control"
                                                               id="waived_notes"
                                                               rows="3"><?php echo e(old('notes')); ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-default pull-left"
                                                    data-dismiss="modal"><?php echo e(trans_choice('general.close',1)); ?></button>
                                            <button type="submit"
                                                    class="btn btn-primary"><?php echo e(trans_choice('general.save',1)); ?></button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="modal fade" id="add_charge_modal">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.charge',1)); ?></h4>
                                    </div>
                                    <form method="post" action="<?php echo e(url('loan/'.$loan->id.'/charge/store')); ?>"
                                          class="form-horizontal "
                                          enctype="multipart/form-data" id="add_charge_form">
                                        <?php echo e(csrf_field()); ?>

                                        <div class="modal-body">
                                            <div class="form-group">
                                                <label for="charge_id"
                                                       class="control-label col-md-3"><?php echo e(trans_choice('general.charge',1)); ?></label>
                                                <div class="col-md-9">
                                                    <select name="charge_id" class="select2 form-control"
                                                            id="charge_id" required>
                                                        <option></option>
                                                        <?php $__currentLoopData = \App\Models\Charge::where('active', 1)->where('product', "loan")->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($key->id); ?>"><?php echo e($key->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                   


                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="charge_date"
                                                       class="control-label col-md-3"> <?php echo e(trans_choice('general.date',1)); ?></label>
                                                <div class="col-md-9">
                                                    <input type="text" name="date"
                                                           class="form-control date-picker"
                                                           value="<?php echo e(date("Y-m-d")); ?>"
                                                           required id="charge_date">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="charge_amount"
                                                       class="control-label col-md-3"><?php echo e(trans_choice('general.amount',1)); ?></label>
                                                <div class="col-md-9">
                                                    <input type="number" name="amount" class="form-control"
                                                           value=""
                                                           required id="charge_amount">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="charge_notes"
                                                       class="control-label col-md-3"><?php echo e(trans_choice('general.note',2)); ?></label>
                                                <div class="col-md-9">
                                                     <textarea name="notes" class="form-control"
                                                               id="charge_notes"
                                                               rows="3"><?php echo e(old('notes')); ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-default pull-left"
                                                    data-dismiss="modal"><?php echo e(trans_choice('general.close',1)); ?></button>
                                            <button type="submit"
                                                    class="btn btn-primary"><?php echo e(trans_choice('general.save',1)); ?></button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="modal fade" id="write_off_loan_modal">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title"><?php echo e(trans_choice('general.write_off',1)); ?> <?php echo e(trans_choice('general.loan',1)); ?></h4>
                                    </div>
                                    <form method="post" action="<?php echo e(url('loan/'.$loan->id.'/write_off')); ?>"
                                          class="form-horizontal "
                                          enctype="multipart/form-data" id="write_off_loan_form">
                                        <?php echo e(csrf_field()); ?>

                                        <div class="form-group">
                                            <label for="written_off_date"
                                                   class="control-label col-md-3"> <?php echo e(trans_choice('general.date',1)); ?></label>
                                            <div class="col-md-9">
                                                <input type="text" name="written_off_date"
                                                       class="form-control date-picker"
                                                       value="<?php echo e(date("Y-m-d")); ?>"
                                                       required id="written_off_date">
                                            </div>
                                        </div>
                                        <div class="modal-body">
                                            <div class="form-group">
                                                <label for="written_off_notes"
                                                       class="control-label col-md-3"><?php echo e(trans_choice('general.note',2)); ?></label>
                                                <div class="col-md-9">
                                                     <textarea name="written_off_notes" class="form-control"
                                                               id="written_off_notes" rows="3"
                                                               required><?php echo e(old('written_off_notes')); ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-default pull-left"
                                                    data-dismiss="modal"><?php echo e(trans_choice('general.close',1)); ?></button>
                                            <button type="submit"
                                                    class="btn btn-primary"><?php echo e(trans_choice('general.save',1)); ?></button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($loan->client_type=="group"): ?>
                        <div class="tab-pane" id="group_allocation">
                            <div class="row">
                                <div class="col-md-12 table-responsive">
                                    <table class="table table-hover table-striped" id="">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(trans_choice('general.name',1)); ?></th>
                                            <th><?php echo e(trans('general.id')); ?></th>
                                            <th><?php echo e(trans('general.amount')); ?></th>
                                            <th><?php echo e(trans_choice('general.action',1)); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $loan->group_allocation; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <?php if(!empty($key->client)): ?>
                                                    <td>
                                                        <?php if($key->client->client_type=="individual"): ?>
                                                            <?php echo e($key->client->first_name); ?> <?php echo e($key->client->middle_name); ?> <?php echo e($key->client->last_name); ?>

                                                        <?php else: ?>
                                                            <?php echo e($key->client->full_name); ?>

                                                        <?php endif; ?>
                                                    </td>
                                                    <td><?php echo e($key->client->account_no); ?></td>
                                                    <td>
                                                        <?php echo e(number_format($key->amount,2)); ?>

                                                    </td>
                                                    <td>
                                                        <a class="" href="<?php echo e(url('client/'.$key->client_id.'/show')); ?>"><i
                                                                    class="fa fa-eye"></i> </a>
                                                    </td>
                                                <?php endif; ?>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="change_loan_officer_modal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title"><?php echo e(trans_choice('general.change',1)); ?> <?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.officer',1)); ?></h4>
                </div>
                <form method="post" action="<?php echo e(url('loan/'.$loan->id.'/change_loan_officer')); ?>"
                      class="form-horizontal "
                      enctype="multipart/form-data" id="change_loan_officer_form">
                    <?php echo e(csrf_field()); ?>

                    <div class="modal-body">
                        <div class="form-group">
                            <label for="loan_officer_id"
                                   class="control-label col-md-3">
                                <?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.officer',1)); ?>

                            </label>
                            <div class="col-md-9">
                                <select name="loan_officer_id" class="form-control select2"
                                        id="loan_officer_id" required>
                                    <option></option>
                                    <?php $__currentLoopData = \App\Models\User::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(!Sentinel::findUserById($key->id)->inRole('client')): ?>
                                            <option value="<?php echo e($key->id); ?>"
                                                    <?php if($loan->loan_officer_id==$key->id): ?> selected <?php endif; ?>><?php echo e($key->first_name); ?> <?php echo e($key->last_name); ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default pull-left"
                                data-dismiss="modal"><?php echo e(trans_choice('general.close',1)); ?></button>
                        <button type="submit"
                                class="btn btn-primary"><?php echo e(trans_choice('general.save',1)); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" id="add_document_modal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.document',1)); ?></h4>
                </div>
                <form method="post" action="<?php echo e(url('loan/'.$loan->id.'/document/store')); ?>"
                      class="form-horizontal "
                      enctype="multipart/form-data" id="add_document_form">
                    <?php echo e(csrf_field()); ?>

                    <div class="modal-body">

                        <div class="form-group">
                            <label for="document_name"
                                   class="control-label col-md-3"><?php echo e(trans_choice('general.name',1)); ?></label>
                            <div class="col-md-9">
                                <input type="text" name="name" class="form-control"
                                       value="<?php echo e(old('name')); ?>"
                                       required id="document_name">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="document_notes"
                                   class="control-label col-md-3"><?php echo e(trans_choice('general.description',2)); ?></label>
                            <div class="col-md-9">
       <textarea name="notes" class="form-control"
                 id="document_notes" rows="3"><?php echo e(old('notes')); ?></textarea>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="document_attachment"
                                   class="control-label col-md-3"><?php echo e(trans_choice('general.attachment',1)); ?></label>
                            <div class="col-md-9">
                                <input type="file" name="attachment" class="form-control" required
                                       id="document_attachment">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default pull-left"
                                data-dismiss="modal"><?php echo e(trans_choice('general.close',1)); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(trans_choice('general.save',1)); ?></button>
                    </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <div class="modal fade" id="add_note_modal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.note',1)); ?></h4>
                </div>
                <form method="post" action="<?php echo e(url('loan/'.$loan->id.'/note/store')); ?>"
                      class="form-horizontal "
                      enctype="multipart/form-data" id="add_note_form">
                    <?php echo e(csrf_field()); ?>

                    <div class="modal-body">

                        <div class="form-group">
                            <label for="note_notes"
                                   class="control-label col-md-3"><?php echo e(trans_choice('general.note',1)); ?></label>
                            <div class="col-md-9">
       <textarea name="notes" class="form-control"
                 id="note_notes" rows="3" required><?php echo e(old('notes')); ?></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default pull-left"
                                data-dismiss="modal"><?php echo e(trans_choice('general.close',1)); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(trans_choice('general.save',1)); ?></button>
                    </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <div class="modal fade" id="view_note">
        <div class="modal-dialog">
            <div class="modal-content">
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <div class="modal fade" id="edit_note">
        <div class="modal-dialog">
            <div class="modal-content">
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <div class="modal fade" id="add_collateral_modal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.collateral',1)); ?></h4>
                </div>
                <form method="post" action="<?php echo e(url('loan/'.$loan->id.'/collateral/store')); ?>"
                      class="form-horizontal"
                      enctype="multipart/form-data" id="add_collateral_form">
                    <?php echo e(csrf_field()); ?>

                    <div class="modal-body">
                        <div class="form-group">
                            <label for="collateral_type_id"
                                   class="control-label col-md-3"><?php echo e(trans_choice('general.type',1)); ?></label>
                            <div class="col-md-9">
                                <select name="collateral_type_id" class="select2 form-control"
                                        id="collateral_type_id" required>
                                    <option></option>
                                    <?php $__currentLoopData = \App\Models\CollateralType::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key->id); ?>"><?php echo e($key->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="value"
                                   class="control-label col-md-3"><?php echo e(trans_choice('general.value',1)); ?></label>
                            <div class="col-md-9">
                                <input type="number" name="value" class="form-control"
                                       value="<?php echo e(old('value')); ?>"
                                       required id="value">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="description"
                                   class="control-label col-md-3"><?php echo e(trans_choice('general.description',1)); ?></label>
                            <div class="col-md-9">
                                <input type="text" name="description" class="form-control"
                                       value="<?php echo e(old('description')); ?>"
                                       required id="description">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="serial"
                                   class="control-label col-md-3"><?php echo e(trans_choice('general.serial',1)); ?></label>
                            <div class="col-md-9">
                                <input type="text" name="serial" class="form-control"
                                       value="<?php echo e(old('serial')); ?>"
                                       required id="serial">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default pull-left"
                                data-dismiss="modal"><?php echo e(trans_choice('general.close',1)); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(trans_choice('general.save',1)); ?></button>
                    </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <div class="modal fade" id="view_collateral">
        <div class="modal-dialog">
            <div class="modal-content">
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <div class="modal fade" id="edit_collateral">
        <div class="modal-dialog">
            <div class="modal-content">
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <div class="modal fade" id="add_guarantor_modal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title"><?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.guarantor',1)); ?></h4>
                </div>
                <form method="post" action="<?php echo e(url('loan/'.$loan->id.'/guarantor/store')); ?>"
                      class="form-horizontal"
                      enctype="multipart/form-data" id="add_guarantor_form">
                    <?php echo e(csrf_field()); ?>

                    <div class="modal-body">
                        <div class="form-group">
                            <label for="is_client"
                                   class="control-label col-md-3"><?php echo e(trans_choice('general.existing',1)); ?> <?php echo e(trans_choice('general.client',1)); ?></label>
                            <div class="col-md-9">
                                <select name="is_client" class="select2 form-control"
                                        id="is_client" required>
                                    <option value="0"><?php echo e(trans_choice('general.no',1)); ?></option>
                                    <option value="1" selected><?php echo e(trans_choice('general.yes',1)); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="" id="clients_div" style="">
                            <div class="form-group">
                                <label for="guarantor_client_id"
                                       class="control-label col-md-3"><?php echo e(trans_choice('general.client',1)); ?></label>
                                <div class="col-md-9">
                                    <select name="client_id" class="form-control select2" id="guarantor_client_id">
                                        <option></option>
                                        <?php $__currentLoopData = \App\Models\Client::where('status', 'active')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key->id); ?>">
                                                <?php if($key->client_type=="individual"): ?>
                                                    <?php echo e($key->first_name); ?> <?php echo e($key->middle_name); ?> <?php echo e($key->last_name); ?>

                                                    (<?php echo e($key->account_no); ?>)
                                                <?php else: ?>
                                                    <?php echo e($key->full_name); ?> (<?php echo e($key->account_no); ?>

                                                    )
                                                <?php endif; ?>
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="lock_funds"
                                       class="control-label col-md-3"><?php echo e(trans_choice('general.lock_funds',1)); ?></label>
                                <div class="col-md-9">
                                    <select name="lock_funds" class="select2 form-control"
                                            id="lock_funds">
                                        <option value="0" selected><?php echo e(trans_choice('general.no',1)); ?></option>
                                        <option value="1"><?php echo e(trans_choice('general.yes',1)); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="client_relationship_id"
                                   class="control-label col-md-3"><?php echo e(trans_choice('general.relationship',1)); ?></label>
                            <div class="col-md-9">
                                <select name="client_relationship_id" class="select2 form-control"
                                        id="client_relationship_id" required>
                                    <option></option>
                                    <?php $__currentLoopData = \App\Models\ClientRelationship::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key->id); ?>"><?php echo e($key->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div id="new_client_div">
                            <div class="form-group">
                                <label for="guarantor_first_name"
                                       class="control-label col-md-3"><?php echo e(trans_choice('general.first_name',1)); ?></label>
                                <div class="col-md-9">
                                    <input type="text" name="first_name" class="form-control"
                                           value="<?php echo e(old('first_name')); ?>"
                                           required id="guarantor_first_name">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="guarantor_middle_name"
                                       class="control-label col-md-3"><?php echo e(trans_choice('general.middle_name',1)); ?></label>
                                <div class="col-md-9">
                                    <input type="text" name="middle_name" class="form-control"
                                           value="<?php echo e(old('middle_name')); ?>"
                                           id="guarantor_middle_name">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="guarantor_last_name"
                                       class="control-label col-md-3"><?php echo e(trans_choice('general.last_name',1)); ?></label>
                                <div class="col-md-9">
                                    <input type="text" name="last_name" class="form-control"
                                           value="<?php echo e(old('last_name')); ?>"
                                           required id="guarantor_last_name">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="guarantor_mobile"
                                       class="control-label col-md-3"><?php echo e(trans_choice('general.mobile',1)); ?></label>
                                <div class="col-md-9">
                                    <input type="text" name="mobile" class="form-control"
                                           value="<?php echo e(old('mobile')); ?>"
                                           id="guarantor_mobile">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="guarantor_gender"
                                       class="control-label col-md-3"><?php echo e(trans_choice('general.gender',1)); ?></label>
                                <div class="col-md-9">
                                    <select name="gender" class="form-control" id="guarantor_gender">
                                        <option value="male"><?php echo e(trans('general.male')); ?></option>
                                        <option value="female"><?php echo e(trans('general.female')); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="guarantor_address"
                                       class="control-label col-md-3"><?php echo e(trans_choice('general.address',1)); ?></label>
                                <div class="col-md-9">
                                    <input type="text" name="guarantor_address" class="form-control"
                                           value=""
                                           id="guarantor_address">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="guarantor_amount"
                                   class="control-label col-md-3"><?php echo e(trans_choice('general.amount',1)); ?></label>
                            <div class="col-md-9">
                                <input type="number" name="amount" class="form-control"
                                       value="<?php echo e(old('amount')); ?>"
                                       required id="guarantor_amount">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default pull-left"
                                data-dismiss="modal"><?php echo e(trans_choice('general.close',1)); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(trans_choice('general.save',1)); ?></button>
                    </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <div class="modal fade" id="view_guarantor">
        <div class="modal-dialog">
            <div class="modal-content">
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <div class="modal fade" id="edit_guarantor">
        <div class="modal-dialog">
            <div class="modal-content">
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>
        if ($("#is_client").val() == 1) {
            $("#clients_div").show();
            $("#new_client_div").hide();
            $("#guarantor_client_id").attr('required', 'required');
            $("#guarantor_first_name").removeAttr('required');
            $("#guarantor_last_name").removeAttr('required');
            $("#guarantor_mobile").removeAttr('required');
        } else if ($("#is_client").val() == 0) {
            $("#clients_div").hide();
            $("#new_client_div").show();
            $("#guarantor_client_id").removeAttr('required');
            $("#guarantor_first_name").attr('required', 'required');
            $("#guarantor_last_name").attr('required', 'required');
            $("#guarantor_mobile").attr('required', 'required');
        } else {
            $("#clients_div").hide();
            $("#clients_div").hide();
        }
        $("#is_client").change(function (e) {
            if ($("#is_client").val() == 1) {
                $("#clients_div").show();
                $("#new_client_div").hide();
                $("#guarantor_client_id").attr('required', 'required');
                $("#guarantor_first_name").removeAttr('required');
                $("#guarantor_last_name").removeAttr('required');
                $("#guarantor_mobile").removeAttr('required');
            } else if ($("#is_client").val() == 0) {
                $("#clients_div").hide();
                $("#new_client_div").show();
                $("#guarantor_client_id").removeAttr('required');
                $("#guarantor_first_name").attr('required', 'required');
                $("#guarantor_last_name").attr('required', 'required');
                $("#guarantor_mobile").attr('required', 'required');
            } else {
                $("#clients_div").hide();
                $("#clients_div").hide();
            }
        });
        $('#view_note').on('shown.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            $.ajax({
                type: 'GET',
                url: "<?php echo url('loan/note'); ?>/" + id + "/show",
                success: function (data) {
                    $(e.currentTarget).find(".modal-content").html(data);
                }
            });
        });
        $('#edit_note').on('shown.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            $.ajax({
                type: 'GET',
                url: "<?php echo url('loan/note'); ?>/" + id + "/edit",
                success: function (data) {
                    $(e.currentTarget).find(".modal-content").html(data);
                }
            });
        })
        $('#view_collateral').on('shown.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            $.ajax({
                type: 'GET',
                url: "<?php echo url('loan/collateral'); ?>/" + id + "/show",
                success: function (data) {
                    $(e.currentTarget).find(".modal-content").html(data);
                }
            });
        });
        $('#edit_collateral').on('shown.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            $.ajax({
                type: 'GET',
                url: "<?php echo url('loan/collateral'); ?>/" + id + "/edit",
                success: function (data) {
                    $(e.currentTarget).find(".modal-content").html(data);
                }
            });
        });
        $('#view_guarantor').on('shown.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            $.ajax({
                type: 'GET',
                url: "<?php echo url('loan/guarantor'); ?>/" + id + "/show",
                success: function (data) {
                    $(e.currentTarget).find(".modal-content").html(data);
                }
            });
        });
        $('#edit_guarantor').on('shown.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            $.ajax({
                type: 'GET',
                url: "<?php echo url('loan/guarantor'); ?>/" + id + "/edit",
                success: function (data) {
                    $(e.currentTarget).find(".modal-content").html(data);
                }
            });
        });
        $("#add_document_form").validate();
        $("#add_collateral_form").validate();
        $("#add_guarantor_form").validate();
        $("#add_note_form").validate();
        $("#approve_loan_form").validate();
        $("#decline_loan_form").validate();
        $("#add_charge_form").validate();
        $("#waive_interest_form").validate();
        $("#write_off_loan_form").validate();
        $('#data-table').DataTable({
            dom: 'frtip',
            "paging": true,
            "lengthChange": true,
            "displayLength": 15,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": true,
            "order": [[4, "desc"]],
            "columnDefs": [
                {"orderable": false, "targets": []}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
        $('#repayments-data-table').DataTable({
            dom: 'frtip',
            "paging": true,
            "lengthChange": true,
            "displayLength": 15,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": true,
            "order": [[1, "asc"]],
            "columnDefs": [
                {"orderable": false, "targets": []}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\bedford-main\resources\views/loan/show.blade.php ENDPATH**/ ?>