<?php


 $loanTransaction = \App\Models\LoanTransaction::where('loan_id', $loan->id)->orderBy('created_at', 'desc');
$loan_allocation = \App\Helpers\GeneralHelper::loan_items($loan->id);



$repaymentAmount = $loan->principal+$loan_allocation['interest'];
$balance = $repaymentAmount;

?>


<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.loan',1)); ?> Statment
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>



    <div class="row">
             <table class="table table-striped table-bordered">
                                    <tbody>
   <?php if($loan->client_type=="client"): ?>
                                        <tr>
                                            <th class="table-bold-loan"><?php echo e(trans_choice('general.client',1)); ?></th>
                                            <td>
                                        <span class="padded-td">
                                             <?php if(!empty($loan->client)): ?>
                                                <?php if($loan->client->client_type=="individual"): ?>
                                                    <a href="<?php echo e(url('client/'.$loan->client_id.'/show')); ?>"><?php echo e($loan->client->first_name); ?> <?php echo e($loan->client->middle_name); ?> <?php echo e($loan->client->last_name); ?></a>

                                                <?php else: ?>
                                                    <a href="<?php echo e(url('client/'.$loan->client_id.'/show')); ?>"><?php echo e($loan->client->full_name); ?></a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </span>
                                            </td>
                                        </tr>
                                    <?php endif; ?>

                                        <tr>
                                            <th class="table-bold-loan">Principal</th>

                                            <td>
                                                <?php echo e(number_format($loan->principal,2)); ?>

                                            </td>
                                        </tr>
                                             <tr>
                                            <th class="table-bold-loan">Interest</th>

                                            <td>
                                                <?php echo e(number_format($loan_allocation['interest'],2)); ?>

                                            </td>
                                        </tr>


                                    </tbody>
                                </table>


        <div class="col-md-12">
            <div class="nav-tabs-custom">
          
                <div class="tab-content">
               
          <div class="row">
                                
                                    <div class="col-md-12 table-responsive">
                                        <table class="pretty displayschedule" 
                                               style="margin-top: 20px;">

                                             <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Repayment Amount</th>
                                                <th>Loan Balance</th>
                                            </tr>
                                            </thead>

                                            <tbody>
                                            <?php $__currentLoopData = $loanTransaction->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <?php 
                                                if ($transaction->transaction_type !== 'repayment') {
                                                    continue;
                                                }
                                                $balance = $balance-$transaction->credit;
                                                ?>

                                                <tr>
                                                    <td><?php echo e($transaction->date); ?></td>
                                                    <td><?php echo e($transaction->credit); ?></td>
                                                    <td><?php echo e($balance); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </table>
                                    </div>

                                    </div>
               
                
                 
             
               
                </div>
            </div>
        </div>
    </div>



<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>
        if ($("#is_client").val() == 1) {
            $("#clients_div").show();
            $("#new_client_div").hide();
            $("#guarantor_client_id").attr('required', 'required');
            $("#guarantor_first_name").removeAttr('required');
            $("#guarantor_last_name").removeAttr('required');
            $("#guarantor_mobile").removeAttr('required');
        } else if ($("#is_client").val() == 0) {
            $("#clients_div").hide();
            $("#new_client_div").show();
            $("#guarantor_client_id").removeAttr('required');
            $("#guarantor_first_name").attr('required', 'required');
            $("#guarantor_last_name").attr('required', 'required');
            $("#guarantor_mobile").attr('required', 'required');
        } else {
            $("#clients_div").hide();
            $("#clients_div").hide();
        }
        $("#is_client").change(function (e) {
            if ($("#is_client").val() == 1) {
                $("#clients_div").show();
                $("#new_client_div").hide();
                $("#guarantor_client_id").attr('required', 'required');
                $("#guarantor_first_name").removeAttr('required');
                $("#guarantor_last_name").removeAttr('required');
                $("#guarantor_mobile").removeAttr('required');
            } else if ($("#is_client").val() == 0) {
                $("#clients_div").hide();
                $("#new_client_div").show();
                $("#guarantor_client_id").removeAttr('required');
                $("#guarantor_first_name").attr('required', 'required');
                $("#guarantor_last_name").attr('required', 'required');
                $("#guarantor_mobile").attr('required', 'required');
            } else {
                $("#clients_div").hide();
                $("#clients_div").hide();
            }
        });
        $('#view_note').on('shown.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            $.ajax({
                type: 'GET',
                url: "<?php echo url('loan/note'); ?>/" + id + "/show",
                success: function (data) {
                    $(e.currentTarget).find(".modal-content").html(data);
                }
            });
        });
        $('#edit_note').on('shown.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            $.ajax({
                type: 'GET',
                url: "<?php echo url('loan/note'); ?>/" + id + "/edit",
                success: function (data) {
                    $(e.currentTarget).find(".modal-content").html(data);
                }
            });
        })
        $('#view_collateral').on('shown.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            $.ajax({
                type: 'GET',
                url: "<?php echo url('loan/collateral'); ?>/" + id + "/show",
                success: function (data) {
                    $(e.currentTarget).find(".modal-content").html(data);
                }
            });
        });
        $('#edit_collateral').on('shown.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            $.ajax({
                type: 'GET',
                url: "<?php echo url('loan/collateral'); ?>/" + id + "/edit",
                success: function (data) {
                    $(e.currentTarget).find(".modal-content").html(data);
                }
            });
        });
        $('#view_guarantor').on('shown.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            $.ajax({
                type: 'GET',
                url: "<?php echo url('loan/guarantor'); ?>/" + id + "/show",
                success: function (data) {
                    $(e.currentTarget).find(".modal-content").html(data);
                }
            });
        });
        $('#edit_guarantor').on('shown.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            $.ajax({
                type: 'GET',
                url: "<?php echo url('loan/guarantor'); ?>/" + id + "/edit",
                success: function (data) {
                    $(e.currentTarget).find(".modal-content").html(data);
                }
            });
        });
        $("#add_document_form").validate();
        $("#add_collateral_form").validate();
        $("#add_guarantor_form").validate();
        $("#add_note_form").validate();
        $("#approve_loan_form").validate();
        $("#decline_loan_form").validate();
        $("#add_charge_form").validate();
        $("#waive_interest_form").validate();
        $("#write_off_loan_form").validate();
        $('#data-table').DataTable({
            dom: 'frtip',
            "paging": true,
            "lengthChange": true,
            "displayLength": 15,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": true,
            "order": [[4, "desc"]],
            "columnDefs": [
                {"orderable": false, "targets": []}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
        $('#repayments-data-table').DataTable({
            dom: 'frtip',
            "paging": true,
            "lengthChange": true,
            "displayLength": 15,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": true,
            "order": [[1, "asc"]],
            "columnDefs": [
                {"orderable": false, "targets": []}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\changa\Documents\Projects\bedford-main\bedford-main\resources\views/loan/statement.blade.php ENDPATH**/ ?>