<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.campaign',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title"><?php echo e(trans_choice('general.campaign',2)); ?></h3>

            <div class="box-tools pull-right">
                <?php if(Sentinel::hasAccess('communication.create')): ?>
                    <a href="<?php echo e(url('communication/create')); ?>" class="btn btn-info btn-sm">
                        <?php echo e(trans_choice('general.add',1)); ?> <?php echo e(trans_choice('general.campaign',1)); ?>

                    </a>
                <?php endif; ?>
            </div>
        </div>
        <div class="box-body table-responsive">
            <table class="table  table-bordered table-hover table-striped" id="data-table">
                <thead>
                <tr>
                    <th><?php echo e(trans_choice('general.name',1)); ?></th>
                    <th><?php echo e(trans_choice('general.type',1)); ?></th>
                    <th><?php echo e(trans_choice('general.message',2)); ?></th>
                    <th><?php echo e(trans_choice('general.created_by',1)); ?></th>
                    <th><?php echo e(trans_choice('general.campaign',1)); ?> <?php echo e(trans_choice('general.type',1)); ?></th>
                    <th><?php echo e(trans_choice('general.status',1)); ?></th>
                    <th><?php echo e(trans_choice('general.date',1)); ?></th>
                    <th><?php echo e(trans_choice('general.action',1)); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key->name); ?></td>
                        <td>
                            <?php if($key->type=="sms"): ?>
                                <?php echo e(trans_choice('general.sms',1)); ?>

                            <?php endif; ?>
                            <?php if($key->type=="email"): ?>
                                <?php echo e(trans_choice('general.email',1)); ?>

                            <?php endif; ?>
                        </td>
                        <td><?php echo e(\App\Helpers\GeneralHelper::limit_text(strip_tags($key->message),4)); ?></td>
                        <td>
                            <?php if(!empty($key->created_by)): ?>
                                <?php echo e($key->created_by->first_name); ?> <?php echo e($key->created_by->last_name); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($key->recurrence_type=="none"): ?>
                                <?php echo e(trans_choice('general.direct',1)); ?>

                            <?php endif; ?>
                            <?php if($key->recurrence_type=="schedule"): ?>
                                <?php echo e(trans_choice('general.schedule',1)); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($key->status=="pending"): ?>
                                <?php echo e(trans_choice('general.pending',1)); ?>

                            <?php endif; ?>
                            <?php if($key->status=="active"): ?>
                                <?php echo e(trans_choice('general.active',1)); ?>

                            <?php endif; ?>
                            <?php if($key->status=="declined"): ?>
                                <?php echo e(trans_choice('general.declined',1)); ?>

                            <?php endif; ?>
                            <?php if($key->status=="inactive"): ?>
                                <?php echo e(trans_choice('general.inactive',1)); ?>

                            <?php endif; ?>
                        </td>
                        <td><?php echo e($key->created_at); ?></td>
                        <td>
                            <div class="btn-group">
                                <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown"
                                        aria-expanded="false"><i
                                            class="fa fa-navicon"></i></button>
                                <ul class="dropdown-menu dropdown-menu-right" role="menu">
                                    <?php if(Sentinel::hasAccess('communication.view')): ?>
                                        <li class="hidden">
                                            <a href="<?php echo e(url('communication/'.$key->id.'/show')); ?>"><i
                                                        class="fa fa-search"></i>
                                                <?php echo e(trans_choice('general.detail',2)); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(Sentinel::hasAccess('communication.update') && $key->recurrence_type!="none"): ?>
                                        <li class="hidden">
                                            <a href="<?php echo e(url('communication/'.$key->id.'/edit')); ?>"><i
                                                        class="fa fa-edit"></i>
                                                <?php echo e(trans('general.edit')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(Sentinel::hasAccess('communication.delete')): ?>
                                        <li>
                                            <a href="<?php echo e(url('communication/'.$key->id.'/delete')); ?>"
                                               class="delete"><i
                                                        class="fa fa-trash"></i>
                                                <?php echo e(trans('general.delete')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>

        $('#data-table').DataTable({
            dom: 'frtip',
            "paging": true,
            "lengthChange": true,
            "displayLength": 15,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": true,
            "order": [[0, "asc"]],
            "columnDefs": [
                {"orderable": false, "targets": []}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\bedford-main\resources\views/communication/data.blade.php ENDPATH**/ ?>