
<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.repayment',2)); ?> <?php echo e(trans_choice('general.report',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title">
                <?php echo e(trans_choice('general.repayment',2)); ?> <?php echo e(trans_choice('general.report',1)); ?>

                <?php if(!empty($start_date)): ?>
                    for period: <b><?php echo e($start_date); ?> to <?php echo e($end_date); ?></b>
                <?php endif; ?>
            </h3>

            <div class="box-tools pull-right">

            </div>
        </div>
        <div class="box-body hidden-print">
            <form method="post" action="<?php echo e(Request::url()); ?>" class="form-horizontal" enctype="multipart/form-data">
                <?php echo e(csrf_field()); ?>

                <div class="form-group">
                    <label for="start_date"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.start',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="start_date" class="form-control date-picker"
                               value="<?php echo e($start_date); ?>"
                               required id="start_date">
                    </div>
                </div>
                <div class="form-group">
                    <label for="end_date"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.end',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></label>
                    <div class="col-md-3">
                        <input type="text" name="end_date" class="form-control date-picker"
                               value="<?php echo e($end_date); ?>"
                               required id="end_date">
                    </div>
                </div>
                <div class="form-group">
                    <label for="office_id"
                           class="control-label col-md-2"><?php echo e(trans_choice('general.office',1)); ?></label>
                    <div class="col-md-3">
                        <select name="office_id" class="form-control select2" id="office_id" required>
                            <option value="0"
                                    <?php if($office_id=="0"): ?> selected <?php endif; ?>><?php echo e(trans_choice('general.all',1)); ?></option>
                            <?php $__currentLoopData = \App\Models\Office::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key->id); ?>"
                                        <?php if($office_id==$key->id): ?> selected <?php endif; ?>><?php echo e($key->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label for=""
                           class="control-label col-md-2"></label>
                    <div class="col-md-4">
                        <button type="submit" class="btn btn-success"><?php echo e(trans_choice('general.search',1)); ?>!
                        </button>

                        <a href="<?php echo e(Request::url()); ?>"
                           class="btn btn-danger"><?php echo e(trans_choice('general.reset',1)); ?>!</a>

                        <div class="btn-group">
                            <button type="button" class="btn bg-blue dropdown-toggle legitRipple"
                                    data-toggle="dropdown"><?php echo e(trans_choice('general.download',1)); ?> <?php echo e(trans_choice('general.report',1)); ?>

                                <span class="caret"></span></button>
                            <ul class="dropdown-menu dropdown-menu-right">
                                <li>
                                    <a href="<?php echo e(url('report/loan_report/repayments_report/pdf?start_date='.$start_date.'&end_date='.$end_date.'&office_id='.$office_id)); ?>"
                                       target="_blank"><i
                                                class="icon-file-pdf"></i> <?php echo e(trans_choice('general.download',1)); ?> <?php echo e(trans_choice('general.to',1)); ?> <?php echo e(trans_choice('general.pdf',1)); ?>

                                    </a></li>
                                <li>
                                    <a href="<?php echo e(url('report/loan_report/repayments_report/excel?start_date='.$start_date.'&end_date='.$end_date.'&office_id='.$office_id)); ?>"
                                       target="_blank"><i
                                                class="icon-file-excel"></i> <?php echo e(trans_choice('general.download',1)); ?> <?php echo e(trans_choice('general.to',1)); ?> <?php echo e(trans_choice('general.excel',1)); ?>

                                    </a></li>
                                <li>
                                    <a href="<?php echo e(url('report/loan_report/repayments_report/csv?start_date='.$start_date.'&end_date='.$end_date.'&office_id='.$office_id)); ?>"
                                       target="_blank"><i
                                                class="icon-download"></i> <?php echo e(trans_choice('general.download',1)); ?> <?php echo e(trans_choice('general.to',1)); ?> <?php echo e(trans_choice('general.csv',1)); ?>

                                    </a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </form>

        </div>
        <!-- /.box-body -->

    </div>

    <!-- /.box -->
    <?php if(!empty($start_date)): ?>
        <div class="box box-primary">
            <div class="box-body table-responsive ">
                <table class="table  table-condensed table-hover">
                    <tbody>
                    <tr style="height: 25pt">
                        <td colspan="11" valign="middle"
                            class="style-1"> <?php echo e(trans_choice('general.loan',1)); ?>  <?php echo e(trans_choice('general.repayment',2)); ?></td>
                    </tr>
                    <tr style="height: 15pt">
                        <td valign="middle" class="style-2"><?php echo e(trans_choice('general.from',1)); ?> :</td>
                        <td valign="middle" class="style-3"><?php echo e($start_date); ?></td>
                        <td colspan="2" valign="middle"
                            class="style-4"><?php echo e(trans_choice('general.report',1)); ?> <?php echo e(trans_choice('general.run',1)); ?> <?php echo e(trans_choice('general.date',1)); ?>

                            :
                        </td>
                        <td colspan="3" valign="middle" class="style-5"> <?php echo e(date("Y-m-d H:i:s")); ?></td>
                        <td colspan="4"></td>
                    </tr>
                    <tr style="height: 45pt">
                        <td valign="middle" class="style-2"><?php echo e(trans_choice('general.to',1)); ?> :</td>
                        <td valign="middle" class="style-3"><?php echo e($end_date); ?></td>
                        <td colspan="9"></td>
                    </tr>
                    <tr class="">
                        <td><?php echo e(trans_choice('general.id',1)); ?></td>
                        <td><?php echo e(trans_choice('general.client',1)); ?></td>
                        <td><?php echo e(trans_choice('general.loan',1)); ?>#</td>
                        <td><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.officer',1)); ?> </td>
                        <td><?php echo e(trans_choice('general.principal',1)); ?></td>
                        <td><?php echo e(trans_choice('general.interest',1)); ?></td>
                        <td><?php echo e(trans_choice('general.fee',2)); ?></td>
                        <td><?php echo e(trans_choice('general.penalty',2)); ?></td>
                        <td><?php echo e(trans_choice('general.total',1)); ?></td>
                        <td><?php echo e(trans_choice('general.date',1)); ?></td>
                        <td><?php echo e(trans_choice('general.channel',1)); ?></td>
                    </tr>
                    <?php
                    $total_principal = 0;
                    $total_fees = 0;
                    $total_interest = 0;
                    $total_penalty = 0;
                    $decimals = 0;
                    ?>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        if (!empty($key->loan)) {
                            $decimals = $key->loan->decimals;
                        } else {
                            $decimals = 0;
                        }
                        $principal = $key->principal_derived;
                        $interest = $key->interest_derived;
                        $fees = $key->fees_derived;
                        $penalty = $key->penalty_derived;
                        $total_principal = $total_principal + $principal;
                        $total_interest = $total_interest + $interest;
                        $total_fees = $total_fees + $fees;
                        $total_penalty = $total_penalty + $penalty;

                        ?>
                        <tr>
                            <td><?php echo e($key->id); ?></td>
                            <td>
                                <?php if(!empty($key->loan)): ?>
                                    <?php if($key->loan->client_type=="client"): ?>
                                        <?php if(!empty($key->loan->client)): ?>
                                            <?php if($key->loan->client->client_type=="individual"): ?>
                                                <?php echo e($key->loan->client->first_name); ?> <?php echo e($key->loan->client->middle_name); ?> <?php echo e($key->loan->client->last_name); ?>

                                            <?php endif; ?>
                                            <?php if($key->loan->client->client_type=="business"): ?>
                                                <?php echo e($key->loan->client->full_name); ?>

                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <?php if($key->loan->client_type=="group"): ?>
                                        <?php if(!empty($key->loan->group)): ?>
                                            <?php echo e($key->loan->group->name); ?>

                                        <?php endif; ?>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($key->loan->id); ?></td>
                            <td>
                                <?php if(!empty($key->loan)): ?>
                                    <?php if(!empty($key->loan->loan_officer)): ?>
                                        <?php echo e($key->loan->loan_officer->first_name); ?>  <?php echo e($key->loan->loan_officer->last_name); ?>

                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e(number_format($principal,$decimals)); ?></td>
                            <td><?php echo e(number_format($interest,$decimals)); ?></td>
                            <td><?php echo e(number_format($fees,$decimals)); ?></td>
                            <td><?php echo e(number_format($penalty,$decimals)); ?></td>
                            <td><?php echo e(number_format($principal+$interest+$fees+$penalty,$decimals)); ?></td>
                            <td><?php echo e($key->date); ?></td>
                            <td>
                                <?php if(!empty($key->payment_detail)): ?>
                                    <?php if(!empty($key->payment_detail->type)): ?>
                                        <?php echo e($key->payment_detail->type->name); ?>

                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <td colspan="4"></td>
                        <td><b><?php echo e(number_format($total_principal,$decimals)); ?></b></td>
                        <td><b><?php echo e(number_format($total_interest,$decimals)); ?></b></td>
                        <td><b><?php echo e(number_format($total_fees,$decimals)); ?></b></td>
                        <td><b><?php echo e(number_format($total_penalty,$decimals)); ?></b></td>
                        <td>
                            <b><?php echo e(number_format($total_principal+$total_interest+$total_fees+$total_penalty,$decimals)); ?></b>
                        </td>
                        <td colspan="3"></td>
                    </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\changa\Documents\Projects\bedford-main\bedford-main\resources\views/loan_report/repayments_report.blade.php ENDPATH**/ ?>